/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static File resizeImage(File image, String destImageDir, Integer width, Integer height) {
        String destFile = destImageDir + File.separator + image.getName();
        File destFileObj = new File(destFile);
        if (image.getAbsolutePath().toLowerCase().contains(".jpg") && image.length() > 0L) {
            if (!destFileObj.exists()) {
                try {
                    FileInputStream input = new FileInputStream(image);
                    InputStream resizedImage = ImageUtil.scaleImage(input, width, height);
                    int data = resizedImage.read();
                    FileOutputStream output = new FileOutputStream(destFile);
                    while (data != -1) {
                        output.write(data);
                        data = resizedImage.read();
                    }
                    output.close();
                    ((InputStream)input).close();
                    input = null;
                    resizedImage.close();
                    resizedImage = null;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("  File already exists: " + destFile);
            }
        }
        return destFileObj;
    }

    public static InputStream scaleImage(InputStream p_image, int p_width, int p_height) throws Exception {
        int imageHeight;
        int thumbWidth = p_width;
        int thumbHeight = p_height;
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        BufferedImage src = ImageIO.read(p_image);
        int imageWidth = src.getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = src.getHeight(null));
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage dest = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D g = dest.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance((double)thumbWidth / (double)src.getWidth(), (double)thumbHeight / (double)src.getHeight());
        g.drawRenderedImage(src, at);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        ImageIO.write((RenderedImage)dest, "JPG", ios);
        ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
        return bis;
    }
}

