/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyalValue;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.PlacemarkDetailDto;

@Controller
@RequestMapping(value={"/placemark_details"})
public class PlacemarkDetailsRestService {
    private static final Logger log = Logger.getLogger(PlacemarkDetailsRestService.class.getName());
    private SurveyedLocaleDao localeDao = new SurveyedLocaleDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> getDetails(@RequestParam(value="placemarkId", defaultValue="") String placemarkId) {
        if (StringUtils.isEmpty((String)placemarkId)) {
            String msg = "[placemarkId] is a required parameter";
            log.log(Level.SEVERE, "[placemarkId] is a required parameter");
            throw new HttpMessageNotReadableException("[placemarkId] is a required parameter");
        }
        SurveyedLocale sl = this.localeDao.getById(Long.valueOf(placemarkId));
        if (sl == null) {
            String msg = "placemarkId : " + placemarkId + " not found";
            log.log(Level.SEVERE, msg);
            throw new HttpMessageNotReadableException(msg);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("placemark_details", this.getPlacemarkDetails(sl));
        return response;
    }

    private List<PlacemarkDetailDto> getPlacemarkDetails(SurveyedLocale sl) {
        ArrayList<PlacemarkDetailDto> details = new ArrayList<PlacemarkDetailDto>();
        if (sl.getSurveyalValues() == null) {
            return details;
        }
        for (SurveyalValue sv : sl.getSurveyalValues()) {
            PlacemarkDetailDto pmDto = new PlacemarkDetailDto();
            DtoMarshaller.copyToDto(sv, pmDto);
            pmDto.setPlacemarkId(sl.getKey().getId());
            Integer qgOrder = sv.getQuestionGroupOrder();
            Integer qOrder = sv.getQuestionOrder();
            pmDto.setOrder((qgOrder == null ? 0 : qgOrder) * 1000 + (qOrder == null ? 0 : qOrder));
            details.add(pmDto);
        }
        return details;
    }
}

