/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.exception.RestValidationException;
import javax.servlet.http.HttpServletRequest;

public class PointOfInterestRequest
extends RestRequest {
    private static final long serialVersionUID = 2511688888372190068L;
    private static final String LAT_PARAM = "lat";
    private static final String LON_PARAM = "lon";
    private static final String COUNTRY_PARAM = "country";
    private Double lat;
    private Double lon;
    private String country;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Override
    protected void populateErrors() {
        if (this.country == null && this.lat == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "lat cannot be null if no country is supplied"));
        }
        if (this.country == null && this.lon == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "lon cannot be null if no country is supplied"));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.country = req.getParameter(COUNTRY_PARAM);
        if (this.country != null) {
            this.country = this.country.trim().toUpperCase();
            if (this.country.length() == 0) {
                this.country = null;
            }
        }
        try {
            if (req.getParameter(LAT_PARAM) != null && req.getParameter(LON_PARAM) != null) {
                this.lat = Double.parseDouble(req.getParameter(LAT_PARAM));
                this.lon = Double.parseDouble(req.getParameter(LON_PARAM));
            }
        }
        catch (NumberFormatException e) {
            throw new RestValidationException(new RestError("5002", "Invalid data type", "lat, lon must be doubles"), "Lat/lon must be doubles", (Exception)e);
        }
    }
}

