/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestRequest;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;

public class DataBackoutRequest
extends RestRequest {
    private static final long serialVersionUID = -1311252813916737262L;
    public static final String GET_QUESTION_ACTION = "getQuestions";
    public static final String GET_SURVEY_INSTANCE_ACTION = "getSurveyInstances";
    public static final String DELETE_SURVEY_INSTANCE_ACTION = "deleteQuestionAnswer";
    public static final String DELETE_QUESTION_SUMMARY_ACTION = "deleteQuestionSummary";
    public static final String LIST_INSTANCE_ACTION = "listInstance";
    public static final String LIST_INSTANCE_RESPONSE_ACTION = "listInstanceResponse";
    public static final String LIST_QUESTION_RESPONSE_ACTION = "listQuestionResponse";
    public static final String SURVEY_ID_PARAM = "surveyId";
    public static final String SURVEY_INSTANCE_ID_PARAM = "surveyInstanceId";
    public static final String QUESTION_ID_PARAM = "questionId";
    public static final String COUNTRY_PARAM = "countryCode";
    public static final String DATE_PARAM = "date";
    public static final String INCLUDE_DATE_PARAM = "includeDate";
    public static final String LAST_COLLECTION_PARAM = "lastCollection";
    public static final String FROM_DATE_PARAM = "fromDate";
    public static final String TO_DATE_PARAM = "toDate";
    public static final String LIMIT_PARAM = "limit";
    private static final ThreadLocal<DateFormat> inFmt = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private Long surveyId;
    private Long surveyInstanceId;
    private Long questionId;
    private String countryCode;
    private boolean includeDate;
    private boolean lastCollection = false;
    private Date fromDate;
    private Date toDate;
    private Integer limit;

    public Long getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Long getSurveyInstanceId() {
        return this.surveyInstanceId;
    }

    public void setSurveyInstanceId(Long surveyInstanceId) {
        this.surveyInstanceId = surveyInstanceId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Long getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(Long questionId) {
        this.questionId = questionId;
    }

    public boolean includeDate() {
        return this.includeDate;
    }

    public void setLastCollection(boolean lastCollection) {
        this.lastCollection = lastCollection;
    }

    public boolean getLastCollection() {
        return this.lastCollection;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    protected void populateErrors() {
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        String instanceId;
        if (req.getParameter(SURVEY_ID_PARAM) != null) {
            this.surveyId = Long.parseLong(req.getParameter(SURVEY_ID_PARAM).trim());
        }
        if (req.getParameter(QUESTION_ID_PARAM) != null) {
            this.questionId = Long.parseLong(req.getParameter(QUESTION_ID_PARAM).trim());
        }
        if ((instanceId = req.getParameter(SURVEY_INSTANCE_ID_PARAM)) != null && instanceId.trim().length() > 0) {
            this.surveyInstanceId = Long.parseLong(instanceId.trim());
        }
        if (req.getParameter(DATE_PARAM) != null) {
            this.toDate = inFmt.get().parse(req.getParameter(DATE_PARAM));
        }
        this.includeDate = req.getParameter(INCLUDE_DATE_PARAM) != null ? Boolean.parseBoolean(req.getParameter(INCLUDE_DATE_PARAM)) : false;
        if (req.getParameter(FROM_DATE_PARAM) != null) {
            this.fromDate = DataBackoutRequest.parseDate(req.getParameter(FROM_DATE_PARAM));
        }
        if (req.getParameter(TO_DATE_PARAM) != null) {
            Date exclusiveDate = DataBackoutRequest.parseDate(req.getParameter(TO_DATE_PARAM));
            Date date = this.toDate = exclusiveDate == null ? null : new Date(exclusiveDate.getTime() + TimeUnit.DAYS.toMillis(1L));
        }
        if (req.getParameter(LIMIT_PARAM) != null) {
            try {
                this.limit = Integer.parseInt(req.getParameter(LIMIT_PARAM));
            }
            catch (Exception e) {
                this.limit = null;
            }
        }
        this.lastCollection = req.getParameter(LAST_COLLECTION_PARAM) != null && "true".equals(req.getParameter(LAST_COLLECTION_PARAM));
        this.countryCode = req.getParameter(COUNTRY_PARAM);
    }

    private static Date parseDate(String s) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition pp = new ParsePosition(0);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(s, pp);
        }
        catch (Exception e) {
            return null;
        }
    }
}

