/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.helper;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.gis.geography.domain.Country;
import com.gallatinsystems.gis.map.dao.MapControlDao;
import com.gallatinsystems.gis.map.domain.MapControl;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.TechnologyType;

public class KMLHelper {
    private static final Logger log = Logger.getLogger(KMLHelper.class.getName());
    private VelocityEngine engine = new VelocityEngine();

    public KMLHelper() {
        this.engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
        try {
            this.engine.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not initialize velocity", e);
        }
    }

    private String mergeContext(VelocityContext context, String templateName) throws Exception {
        Template t = this.engine.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public String bindPlacemark(AccessPoint ap, String vmName) throws Exception {
        if (ap.getCountryCode() != null && !ap.getCountryCode().equals("MW")) {
            VelocityContext context = new VelocityContext();
            if (ap.getCollectionDate() != null) {
                String formattedDate = DateFormat.getDateInstance(3).format(ap.getCollectionDate());
                context.put("collectionDate", (Object)formattedDate);
            } else {
                context.put("collectionDate", (Object)"N/A");
            }
            context.put("latitude", (Object)ap.getLatitude());
            context.put("longitude", (Object)ap.getLongitude());
            context.put("altitude", (Object)ap.getAltitude());
            if (ap.getCommunityCode() != null) {
                context.put("communityCode", (Object)ap.getCommunityCode());
            } else {
                context.put("communityCode", (Object)("Unknown" + new Date()));
            }
            if (ap.getPhotoURL() != null) {
                context.put("photoUrl", (Object)ap.getPhotoURL());
            } else {
                context.put("photoUrl", (Object)"http://waterforpeople.s3.amazonaws.com/images/wfplogo.jpg");
            }
            if (ap.getPointType() != null) {
                if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.WATER_POINT)) {
                    context.put("typeOfPoint", (Object)"Water");
                    context.put("type", (Object)"water");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.SANITATION_POINT)) {
                    context.put("typeOfPoint", (Object)"Sanitation");
                    context.put("type", (Object)"sanitation");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.PUBLIC_INSTITUTION)) {
                    context.put("typeOfPoint", (Object)"Public Institutions");
                    context.put("type", (Object)"public_institutions");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.HEALTH_POSTS)) {
                    context.put("typeOfPoint", (Object)"Health Posts");
                    context.put("type", (Object)"health_posts");
                } else if (ap.getPointType().equals((Object)AccessPoint.AccessPointType.SCHOOL)) {
                    context.put("typeOfPoint", (Object)"School");
                    context.put("type", (Object)"school");
                }
            } else {
                context.put("typeOfPoint", (Object)"Water");
                context.put("type", (Object)"water");
            }
            if (ap.getTypeTechnologyString() == null) {
                context.put("primaryTypeTechnology", (Object)"Unknown");
            } else {
                context.put("primaryTypeTechnology", (Object)ap.getTypeTechnologyString());
            }
            if (ap.getHasSystemBeenDown1DayFlag() == null) {
                context.put("down1DayFlag", (Object)"Unknown");
            } else {
                context.put("down1DayFlag", (Object)this.encodeBooleanDisplay(ap.getHasSystemBeenDown1DayFlag()));
            }
            if (ap.getInstitutionName() == null) {
                context.put("institutionName", (Object)"Unknown");
            } else {
                context.put("institutionName", (Object)"Unknown");
            }
            if (ap.getConstructionDateYear() == null || ap.getConstructionDateYear().trim().equals("")) {
                context.put("constructionDateOfWaterPoint", (Object)"Unknown");
            } else {
                context.put("constructionDateOfWaterPoint", (Object)ap.getConstructionDateYear());
            }
            if (ap.getNumberOfHouseholdsUsingPoint() == null) {
                context.put("numberOfHouseholdsUsingWaterPoint", (Object)"Unknown");
            } else {
                context.put("numberOfHouseholdsUsingWaterPoint", (Object)ap.getNumberOfHouseholdsUsingPoint());
            }
            if (ap.getCostPer() == null) {
                context.put("costPer", (Object)"N/A");
            } else {
                context.put("costPer", (Object)ap.getCostPer());
            }
            if (ap.getFarthestHouseholdfromPoint() == null || ap.getFarthestHouseholdfromPoint().trim().equals("")) {
                context.put("farthestHouseholdfromWaterPoint", (Object)"N/A");
            } else {
                context.put("farthestHouseholdfromWaterPoint", (Object)ap.getFarthestHouseholdfromPoint());
            }
            if (ap.getCurrentManagementStructurePoint() == null) {
                context.put("currMgmtStructure", (Object)"N/A");
            } else {
                context.put("currMgmtStructure", (Object)ap.getCurrentManagementStructurePoint());
            }
            if (ap.getPointPhotoCaption() == null || ap.getPointPhotoCaption().trim().equals("")) {
                context.put("waterPointPhotoCaption", (Object)"Water For People");
            } else {
                context.put("waterPointPhotoCaption", (Object)ap.getPointPhotoCaption());
            }
            if (ap.getCommunityName() == null) {
                context.put("communityName", (Object)"Unknown");
            } else {
                context.put("communityName", (Object)ap.getCommunityName());
            }
            if (ap.getHeader() == null) {
                context.put("header", (Object)"Water For People");
            } else {
                context.put("header", (Object)ap.getHeader());
            }
            if (ap.getFooter() == null) {
                context.put("footer", (Object)"Water For People");
            } else {
                context.put("footer", (Object)ap.getFooter());
            }
            if (ap.getPhotoName() == null) {
                context.put("photoName", (Object)"Water For People");
            } else {
                context.put("photoName", (Object)ap.getPhotoName());
            }
            if (ap.getMeetGovtQualityStandardFlag() == null) {
                context.put("meetGovtQualityStandardFlag", (Object)"N/A");
            } else {
                context.put("meetGovtQualityStandardFlag", (Object)this.encodeBooleanDisplay(ap.getMeetGovtQualityStandardFlag()));
            }
            if (ap.getMeetGovtQuantityStandardFlag() == null) {
                context.put("meetGovtQuantityStandardFlag", (Object)"N/A");
            } else {
                context.put("meetGovtQuantityStandardFlag", (Object)this.encodeBooleanDisplay(ap.getMeetGovtQuantityStandardFlag()));
            }
            if (ap.getWhoRepairsPoint() == null) {
                context.put("whoRepairsPoint", (Object)"N/A");
            } else {
                context.put("whoRepairsPoint", (Object)ap.getWhoRepairsPoint());
            }
            if (ap.getSecondaryTechnologyString() == null) {
                context.put("secondaryTypeTechnology", (Object)"N/A");
            } else {
                context.put("secondaryTypeTechnology", (Object)ap.getSecondaryTechnologyString());
            }
            if (ap.getProvideAdequateQuantity() == null) {
                context.put("provideAdequateQuantity", (Object)"N/A");
            } else {
                context.put("provideAdequateQuantity", (Object)this.encodeBooleanDisplay(ap.getProvideAdequateQuantity()));
            }
            if (ap.getBalloonTitle() == null) {
                context.put("title", (Object)"Water For People");
            } else {
                context.put("title", (Object)ap.getBalloonTitle());
            }
            if (ap.getProvideAdequateQuantity() == null) {
                context.put("provideAdequateQuantity", (Object)"N/A");
            } else {
                context.put("provideAdequateQuantity", (Object)this.encodeBooleanDisplay(ap.getProvideAdequateQuantity()));
            }
            if (ap.getDescription() != null) {
                context.put("description", (Object)ap.getDescription());
            } else {
                context.put("description", (Object)"Unknown");
            }
            if (ap.getPointType() != null) {
                this.encodeStatus(ap.getPointType(), ap.getPointStatus(), context);
            } else {
                context.put("pinStyle", (Object)"pushpinblk");
            }
            String output = this.mergeContext(context, vmName);
            return output;
        }
        return null;
    }

    private String encodeBooleanDisplay(Boolean value) {
        if (value.booleanValue()) {
            return "Yes";
        }
        return "No";
    }

    private void encodeStatus(AccessPoint.AccessPointType type, AccessPoint.Status status, VelocityContext context) {
        if (type.equals((Object)AccessPoint.AccessPointType.SANITATION_POINT)) {
            context.put("pinStyle", (Object)"pushpinpurple");
        } else if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
            context.put("pinStyle", (Object)"pushpingreen");
        } else if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK)) {
            context.put("pinStyle", (Object)"pushpinyellow");
        } else if (status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
            context.put("pinStyle", (Object)"pushpinred");
        } else if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
            context.put("pinStyle", (Object)"pushpinblk");
        } else {
            context.put("pinStyle", (Object)"pushpinblk");
        }
        this.encodeStatusString(status, context);
    }

    private String encodeStatusString(AccessPoint.Status status, VelocityContext context) {
        if (status != null) {
            if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
                context.put("waterSystemStatus", (Object)"System Functioning and Meets Government Standards");
                return "System Functioning and Meets Government Standards";
            }
            if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK)) {
                context.put("waterSystemStatus", (Object)"Functioning but with Problems");
                return "Functioning but with Problems";
            }
            if (status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
                context.put("waterSystemStatus", (Object)"Broken-down system");
                return "Broken-down system";
            }
            if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
                context.put("waterSystemStatus", (Object)"No Improved System");
                return "No Improved System";
            }
            context.put("waterSystemStatus", (Object)"Unknown");
            return "Unknown";
        }
        context.put("waterSystemStatus", (Object)"Unknown");
        return "Unknown";
    }

    public void buildMap() {
        BaseDAO<Country> countryDao = new BaseDAO<Country>(Country.class);
        MapControl mc = new MapControl();
        mc.setStartDate(new Date());
        List<Country> countryList = countryDao.list("all");
        if (countryList != null) {
            for (Country country : countryList) {
                if (country == null) continue;
            }
        }
    }

    public void buildCountryFragments(String countryCode) {
        BaseDAO<TechnologyType> techTypeDao = new BaseDAO<TechnologyType>(TechnologyType.class);
        List<TechnologyType> techTypeList = techTypeDao.list("all");
        if (countryCode != null) {
            for (TechnologyType tt : techTypeList) {
                if (tt == null) continue;
            }
        }
    }

    public Boolean checkCreateNewMap() {
        Boolean runFlag = false;
        Date lastPointDate = null;
        AccessPointDao apDao = new AccessPointDao();
        List<AccessPoint> apList = apDao.listAccessPointsByDateOrdered("createdDateTime", "desc", null);
        MapControlDao mcDao = new MapControlDao();
        MapControl mc = mcDao.getLatestRunTime();
        if (apList != null && apList.size() > 0 && apList.get(0) != null) {
            lastPointDate = apList.get(0).getCreatedDateTime();
        }
        if (lastPointDate != null && (mc == null || mc.getCreatedDateTime().before(lastPointDate))) {
            runFlag = true;
        }
        return runFlag;
    }
}

