/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.sms.dao.SMSMessageDao;
import com.gallatinsystems.sms.domain.SMSMessage;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.SMSRestRequest;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.domain.AccessPoint;

public class SMSReceiverServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 4059925726791884167L;
    private static final Map<String, AccessPoint.Status> STATUS_MAP = new HashMap<String, AccessPoint.Status>(){
        private static final long serialVersionUID = -549152350427462282L;
        {
            this.put("A", AccessPoint.Status.FUNCTIONING_HIGH);
            this.put("B", AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS);
            this.put("C", AccessPoint.Status.BROKEN_DOWN);
        }
    };
    private AccessPointDao apDao;
    private SMSMessageDao smsDao;

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SMSRestRequest restRequest = new SMSRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        AccessPoint.Status status;
        AccessPoint ap;
        SMSRestRequest smsReq = (SMSRestRequest)req;
        SMSMessage message = new SMSMessage();
        message.setFrom(smsReq.getFrom());
        message.setText(smsReq.getText());
        message.setSentDate(smsReq.getTimestamp());
        this.smsDao.save(message);
        String[] parts = message.getText().split(" ");
        if (parts.length == 2 && (ap = this.apDao.findAccessPointBySMSCode(parts[0])) != null && (status = STATUS_MAP.get(parts[1])) != null) {
            ap.setPointStatus(status);
            this.apDao.save(ap);
        }
        RestResponse resp = new RestResponse();
        resp.setCode("200");
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        resp.setCode("200");
    }
}

