/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.beoui.geocell.GeocellManager;
import com.beoui.geocell.model.GeocellQuery;
import com.beoui.geocell.model.Point;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.PersistenceManager;
import org.waterforpeople.mapping.dao.AccessPointScoreDetailDao;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.AccessPointScoreDetail;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class AccessPointDao
extends BaseDAO<AccessPoint> {
    private static final String SCORE_AP_FLAG = "scoreAPFlag";
    private static final int MAX_RESULTS = 40;

    public AccessPointDao() {
        super(AccessPoint.class);
    }

    public Iterable<Entity> listRawEntity(Boolean returnKeysOnly) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query q = new Query("AccessPoint");
        if (returnKeysOnly.booleanValue()) {
            q.setKeysOnly();
        }
        PreparedQuery pq = datastore.prepare(q);
        return pq.asIterable();
    }

    public Iterable<Entity> listRawEntity(Boolean returnKeysOnly, String countryCode, String communityCode, String accessPointCode, String cursorString) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query q = new Query("AccessPoint");
        int pageSize = 50;
        if (returnKeysOnly.booleanValue()) {
            q.setKeysOnly();
        }
        if (countryCode != null) {
            q.addFilter("countryCode", Query.FilterOperator.EQUAL, (Object)countryCode);
        }
        if (communityCode != null) {
            q.addFilter("communtiyCode", Query.FilterOperator.EQUAL, (Object)communityCode);
        }
        if (accessPointCode != null) {
            q.addFilter("accessPointCode", Query.FilterOperator.EQUAL, (Object)accessPointCode);
        }
        PreparedQuery pq = datastore.prepare(q);
        FetchOptions fetchOptions = FetchOptions.Builder.withLimit((int)pageSize);
        String startCursor = cursorString;
        if (startCursor != null) {
            fetchOptions.startCursor(Cursor.fromWebSafeString((String)startCursor));
        }
        return pq.asIterable(fetchOptions);
    }

    public AccessPoint findByKey(Key key) {
        return (AccessPoint)super.getByKey(key);
    }

    public List<AccessPoint> listNearbyAccessPoints(Double lat, Double lon, String countryCode, double maxDistance, String cursor) {
        PersistenceManager pm = PersistenceFilter.getManager();
        if (lat != null && lon != null) {
            Point loc = new Point(lat.doubleValue(), lon.doubleValue());
            ArrayList<String> params = new ArrayList<String>();
            params.add(countryCode);
            GeocellQuery gq = new GeocellQuery("countryCode == countryCodeParam", "String countryCodeParam", params);
            return GeocellManager.proximityFetch((Point)loc, (int)40, (double)maxDistance, AccessPoint.class, (GeocellQuery)gq, (PersistenceManager)pm);
        }
        return this.listAccessPointByLocation(countryCode, null, null, null, cursor);
    }

    public List<AccessPoint> listAccessPointByLocation(String country, String community, String type, Date updatedSinceDate, String cursorString) {
        return this.listAccessPointByLocation(country, community, type, updatedSinceDate, cursorString, 20);
    }

    public List<AccessPoint> listAccessPointByLocation(String country, String community, String type, Date updatedSinceDate, String cursorString, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("countryCode", filterString, paramString, "String", country, paramMap);
        this.appendNonNullParam("communityCode", filterString, paramString, "String", community, paramMap);
        this.appendNonNullParam("pointType", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("lastUpdateDateTime", filterString, paramString, "Date", updatedSinceDate, paramMap, " >= ");
        if (updatedSinceDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setOrdering("lastUpdateDateTime desc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, pageSize, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    public List<AccessPoint> searchAccessPoints(String country, String community, Date collDateFrom, Date collDateTo, String type, String tech, Date constructionDateFrom, Date constructionDateTo, String orderByField, String orderByDir, Integer pageSize, String cursorString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        javax.jdo.Query query = this.constructQuery(country, community, collDateFrom, collDateTo, type, tech, constructionDateFrom, constructionDateTo, null, orderByField, orderByDir, paramMap);
        this.prepareCursor(cursorString, pageSize, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    public List<AccessPoint> searchAccessPoints(String country, String community, Date collDateFrom, Date collDateTo, String type, String tech, Date constructionDateFrom, Date constructionDateTo, String org, String orderByField, String orderByDir, Integer pageSize, String cursorString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        javax.jdo.Query query = this.constructQuery(country, community, collDateFrom, collDateTo, type, tech, constructionDateFrom, constructionDateTo, org, orderByField, orderByDir, paramMap);
        this.prepareCursor(cursorString, pageSize, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    public void deleteByQuery(String country, String community, Date collDateFrom, Date collDateTo, String type, String tech, Date constructionDateFrom, Date constructionDateTo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        javax.jdo.Query query = this.constructQuery(country, community, collDateFrom, collDateTo, type, tech, constructionDateFrom, constructionDateTo, null, null, null, paramMap);
        query.deletePersistentAll(paramMap);
    }

    public List<AccessPoint> listBySubLevel(String countryCode, Integer level, String subValue, String cursor, AccessPoint.AccessPointType type, Integer desiredResults) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("pointType", filterString, paramString, "String", (Object)type, paramMap);
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap);
        this.appendNonNullParam("sub" + level, filterString, paramString, "String", subValue, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursor, desiredResults, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    private javax.jdo.Query constructQuery(String country, String community, Date collDateFrom, Date collDateTo, String type, String tech, Date constructionDateFrom, Date constructionDateTo, String org, String orderByField, String orderByDir, Map<String, Object> paramMap) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        this.appendNonNullParam("countryCode", filterString, paramString, "String", country, paramMap);
        this.appendNonNullParam("communityCode", filterString, paramString, "String", community, paramMap);
        this.appendNonNullParam("pointType", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("typeTechnologyString", filterString, paramString, "String", tech, paramMap);
        if (org != null) {
            if (org.trim().equalsIgnoreCase("wfp")) {
                this.appendNonNullParam("waterForPeopleProjectFlag", filterString, paramString, "Boolean", true, paramMap);
            } else {
                this.appendNonNullParam("waterForPeopleProjectFlag", filterString, paramString, "Boolean", false, paramMap);
            }
        }
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", collDateFrom, paramMap, " >= ");
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", collDateTo, paramMap, " <= ");
        this.appendNonNullParam("constructionDate", filterString, paramString, "Date", constructionDateFrom, paramMap, " >= ");
        this.appendNonNullParam("constructionDate", filterString, paramString, "Date", constructionDateTo, paramMap, " <= ");
        if (orderByField != null) {
            String ordering = orderByDir;
            if (ordering == null) {
                ordering = "asc";
            }
            query.setOrdering(orderByField + " " + ordering);
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        if (collDateFrom != null || collDateTo != null || constructionDateFrom != null || constructionDateTo != null) {
            query.declareImports("import java.util.Date");
        }
        return query;
    }

    public AccessPoint findAccessPoint(AccessPoint.AccessPointType type, Double lat, Double lon, Date collectionDate) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("pointType", filterString, paramString, "String", (Object)type, paramMap);
        this.appendNonNullParam("latitude", filterString, paramString, "Double", lat, paramMap);
        this.appendNonNullParam("longitude", filterString, paramString, "Double", lon, paramMap);
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", collectionDate, paramMap, " == ");
        query.declareImports("import java.util.Date");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List results = (List)query.executeWithMap(paramMap);
        if (results != null && results.size() >= 1) {
            return (AccessPoint)results.get(0);
        }
        return null;
    }

    public List<AccessPoint> listAccessPointsByTechnology(String countryCode, String technologyType, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(AccessPoint.class);
        q.setFilter("countryCode == countryCodeParam && typeTechnologyString ==  typeTechnologyParam");
        q.declareParameters("String countryCodeParam, String typeTechnologyParam");
        this.prepareCursor(cursorString, q);
        List result = (List)q.execute((Object)countryCode, (Object)technologyType);
        return result;
    }

    public List<AccessPoint> listAccessPointsByDateOrdered(String dateColumn, String orderDirection, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(AccessPoint.class);
        q.setOrdering(dateColumn + " " + orderDirection);
        this.prepareCursor(cursorString, q);
        List result = (List)q.execute();
        return result;
    }

    public List<AccessPoint> listAccessPointBySubLevel(Integer subLevel, String subName, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        javax.jdo.Query q = pm.newQuery(AccessPoint.class);
        this.appendNonNullParam("sub" + subLevel, filterString, paramString, "String", subName, paramMap);
        q.setOrdering("createdDateTime desc");
        q.setFilter(filterString.toString());
        q.declareParameters(paramString.toString());
        List result = (List)q.executeWithMap(paramMap);
        return result;
    }

    public List<AccessPoint> listAccessPointsWithErrors(String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(AccessPoint.class);
        q.setOrdering("createdDateTime desc");
        q.setFilter("latitude == 0.0");
        this.prepareCursor(cursorString, q);
        List result = (List)q.execute();
        return result;
    }

    public AccessPoint findAccessPoint(String communityCode, AccessPoint.AccessPointType pointType) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("communityCode", filterString, paramString, "String", communityCode, paramMap);
        this.appendNonNullParam("pointType", filterString, paramString, "String", pointType.toString(), paramMap);
        query.setOrdering("collectionDate desc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List results = (List)query.executeWithMap(paramMap);
        if (results != null && results.size() >= 1) {
            return (AccessPoint)results.get(0);
        }
        return null;
    }

    public List<AccessPoint> listAccessPointsByBoundingBox(AccessPoint.AccessPointType pointType, Double lat1, Double lat2, Double long1, Double long2, String cursorString, Integer maxResults) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(AccessPoint.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("pointType", filterString, paramString, "String", pointType.toString(), paramMap);
        this.appendNonNullParam("latitude", filterString, paramString, "Double", lat1, paramMap, " <= ");
        this.appendNonNullParam("latitude", filterString, paramString, "Double", lat2, paramMap, " >= ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, maxResults, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    public AccessPoint findAccessPointBySMSCode(String code) {
        List apList = this.listByProperty("smsCode", code, "String");
        AccessPoint latest = null;
        if (apList != null) {
            for (AccessPoint point : apList) {
                if (latest == null) {
                    latest = point;
                    continue;
                }
                if (latest.getCollectionDate() != null && point.getCollectionDate() != null) {
                    if (!latest.getCollectionDate().before(point.getCollectionDate())) continue;
                    latest = point;
                    continue;
                }
                latest = point;
            }
        }
        return latest;
    }

    @Override
    public AccessPoint save(AccessPoint point) {
        if (Boolean.parseBoolean(PropertyUtil.getProperty(SCORE_AP_FLAG))) {
            point = AccessPointHelper.scoreAccessPoint(point);
        }
        if ((point = super.save(point)).getApScoreDetailList() != null) {
            for (AccessPointScoreDetail item : point.getApScoreDetailList()) {
                if (item.getKey() != null) continue;
                item.setAccessPointId(point.getKey().getId());
                AccessPointScoreDetailDao apsddao = new AccessPointScoreDetailDao();
                apsddao.save(item);
            }
        }
        return point;
    }
}

