/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.gis.geography.domain.Country;
import com.gallatinsystems.gis.location.GeoLocationServiceGeonamesImpl;
import com.gallatinsystems.gis.location.GeoPlace;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.dao.CommunityDao;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.Community;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class CommunityLocationSummarizer
implements DataSummarizer {
    Logger logger = Logger.getLogger(CommunityLocationSummarizer.class.getName());

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        AccessPointDao accessPointDao;
        AccessPoint ap;
        if (key != null && (ap = (AccessPoint)(accessPointDao = new AccessPointDao()).getByKey(new Long(key))) != null) {
            CommunityDao commDao = new CommunityDao();
            Community community = commDao.findCommunityByCode(ap.getCommunityCode());
            if (community == null && ap.getLatitude() != null && ap.getLatitude() != 0.0 && ap.getLongitude() != null && ap.getLongitude() != 0.0) {
                String countryCode;
                GeoLocationServiceGeonamesImpl gl = new GeoLocationServiceGeonamesImpl();
                GeoPlace gp = gl.findGeoPlace(ap.getLatitude().toString(), ap.getLongitude().toString());
                if (gp == null && (countryCode = gl.getCountryCodeForPoint(ap.getLatitude().toString(), ap.getLongitude().toString())) != null) {
                    gp = new GeoPlace();
                    gp.setCountryCode(countryCode);
                    gp.setCountryName(countryCode);
                }
                if (gp != null && gp.getCountryCode() != null && gp.getCountryCode().trim().length() <= 3) {
                    Country ourCountry = commDao.findCountryByCode(gp.getCountryCode());
                    if (ourCountry == null) {
                        ourCountry = new Country();
                        ourCountry.setIsoAlpha2Code(gp.getCountryCode());
                        ourCountry.setName(gp.getCountryName());
                        ourCountry.setDisplayName(gp.getCountryName());
                        commDao.save(ourCountry);
                    }
                    community = new Community();
                    community.setCommunityCode(ap.getCommunityCode());
                    community.setName(gp.getName());
                    community.setLat(gp.getLat());
                    community.setLon(gp.getLng());
                    community.setCountryCode(ourCountry.getIsoAlpha2Code());
                    commDao.save(community);
                } else {
                    this.logger.log(Level.SEVERE, "Did not find a country for lat/lon " + ap.getLatitude() + "," + ap.getLongitude() + " using the geonames service");
                }
            }
            if (community != null && community.getName() == null) {
                community.setName(ap.getCommunityName());
            }
            if (ap.getCountryCode() == null && community != null) {
                ap.setCountryCode(community.getCountryCode());
            }
            AccessPointHelper aph = new AccessPointHelper();
            aph.setGeoDetails(ap);
            accessPointDao.save(ap);
        }
        return true;
    }

    @Override
    public String getCursor() {
        return null;
    }
}

