/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.standards.domain.Standard;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.KMLGenerator;
import org.waterforpeople.mapping.domain.AccessPoint;

public class PlacemarkRestRequest
extends RestRequest {
    private static final String DOMAIN_CONFIG_KEY = "domainType";
    public static final String GET_AP_DETAILS_ACTION = "getAPDetails";
    public static final String LIST_BOUNDING_BOX_ACTION = "listByBoundingBox";
    public static final String LIST_COUNTRY_ACTION = "listCountries";
    public static final String LIST_PLACEMARK = "listPlacemarks";
    private static final String COUNTRY_PARAM = "country";
    private static final String NEED_DETAILS_PARM = "needDetailsFlag";
    private static final String COMMUNITY_CODE_PARAM = "communityCode";
    private static final String POINT_TYPE_PARAM = "pointType";
    private static final String DISPLAY_TYPE_PARAM = "display";
    private static final String IGNORE_CACHE_PARAM = "ignoreCache";
    private static final String SUB_LEVEL_PARAM = "subLevel";
    private static final String SUB_LEVEL_VALUE = "subLevelValue";
    private static final String LAT1_PARAM = "lat1";
    private static final String LONG1_PARAM = "long1";
    private static final String LAT2_PARAM = "lat2";
    private static final String LONG2_PARAM = "long2";
    private static final String DOMAIN_PARAM = "domain";
    private static final String ORG_PARAM = "org";
    private static final String STANDARD_TYPE = "standardType";
    private String country;
    private Boolean needDetailsFlag = null;
    private String communityCode = null;
    private String display;
    private AccessPoint.AccessPointType pointType = null;
    private String pointTypeString;
    private Boolean ignoreCache = false;
    private Integer subLevel = null;
    private String subLevelValue = null;
    private Double lat1 = null;
    private Double lat2 = null;
    private Double long1 = null;
    private Double long2 = null;
    private String domain;
    private String org = null;
    private Standard.StandardType standardType = null;
    private static final long serialVersionUID = -3977305417999591917L;

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Double getLat1() {
        return this.lat1;
    }

    public void setLat1(Double lat1) {
        this.lat1 = lat1;
    }

    public Double getLat2() {
        return this.lat2;
    }

    public void setLat2(Double lat2) {
        this.lat2 = lat2;
    }

    public Double getLong1() {
        return this.long1;
    }

    public void setLong1(Double long1) {
        this.long1 = long1;
    }

    public Double getLong2() {
        return this.long2;
    }

    public void setLong2(Double long2) {
        this.long2 = long2;
    }

    public String getSubLevelValue() {
        return this.subLevelValue;
    }

    public void setSubLevelValue(String subLevelValue) {
        this.subLevelValue = subLevelValue;
    }

    public Integer getSubLevel() {
        return this.subLevel;
    }

    public void setSubLevel(Integer subLevel) {
        this.subLevel = subLevel;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.domain = req.getParameter(DOMAIN_PARAM);
        if (this.domain == null) {
            this.domain = PropertyUtil.getProperty(DOMAIN_CONFIG_KEY);
        }
        this.country = req.getParameter(COUNTRY_PARAM);
        if (this.country != null) {
            this.country = this.country.trim().toUpperCase();
            if (this.country.length() == 0) {
                this.country = null;
            }
        }
        if (req.getParameter(SUB_LEVEL_PARAM) != null) {
            this.setSubLevel(Integer.parseInt(req.getParameter(SUB_LEVEL_PARAM)));
        }
        if (req.getParameter(SUB_LEVEL_VALUE) != null) {
            this.setSubLevelValue(req.getParameter(SUB_LEVEL_VALUE));
        }
        if (req.getParameter(COMMUNITY_CODE_PARAM) != null) {
            this.setCommunityCode(req.getParameter(COMMUNITY_CODE_PARAM));
        }
        this.display = req.getParameter(DISPLAY_TYPE_PARAM);
        if (req.getParameter(IGNORE_CACHE_PARAM) != null) {
            this.setIgnoreCache(Boolean.parseBoolean(req.getParameter(IGNORE_CACHE_PARAM)));
        }
        if (req.getParameter(LAT1_PARAM) != null) {
            this.setLat1(Double.parseDouble(req.getParameter(LAT1_PARAM)));
        }
        if (req.getParameter(LAT2_PARAM) != null) {
            this.setLat2(Double.parseDouble(req.getParameter(LAT2_PARAM)));
        }
        if (req.getParameter(LONG1_PARAM) != null) {
            this.setLong1(Double.parseDouble(req.getParameter(LONG1_PARAM)));
        }
        if (req.getParameter(LONG2_PARAM) != null) {
            this.setLong2(Double.parseDouble(req.getParameter(LONG2_PARAM)));
        }
        if (req.getParameter(ORG_PARAM) != null) {
            this.setOrg(req.getParameter(ORG_PARAM));
        }
        if (req.getParameter(POINT_TYPE_PARAM) != null) {
            this.pointTypeString = req.getParameter(POINT_TYPE_PARAM);
            if (AccessPoint.AccessPointType.HEALTH_POSTS.toString().equals(this.pointTypeString)) {
                this.setPointType(AccessPoint.AccessPointType.HEALTH_POSTS);
            } else if (AccessPoint.AccessPointType.PUBLIC_INSTITUTION.toString().equals(this.pointTypeString) || KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_BLACK_ICON_URL.equals(this.pointTypeString) || KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_GREEN_ICON_URL.equals(this.pointTypeString) || KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_RED_ICON_URL.equals(this.pointTypeString) || KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL.equals(this.pointTypeString)) {
                this.setPointType(AccessPoint.AccessPointType.PUBLIC_INSTITUTION);
            } else if (AccessPoint.AccessPointType.SCHOOL.toString().equals(this.pointTypeString) || KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_BLACK_ICON_URL.equals(this.pointTypeString) || KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_GREEN_ICON_URL.equals(this.pointTypeString) || KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_RED_ICON_URL.equals(this.pointTypeString) || KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL.equals(this.pointTypeString)) {
                this.setPointType(AccessPoint.AccessPointType.SCHOOL);
            } else if (this.pointTypeString.equals(AccessPoint.AccessPointType.WATER_POINT.toString()) || KMLGenerator.WATER_POINT_FUNCTIONING_BLACK_ICON_URL.equals(this.pointTypeString) || KMLGenerator.WATER_POINT_FUNCTIONING_GREEN_ICON_URL.equals(this.pointTypeString) || KMLGenerator.WATER_POINT_FUNCTIONING_RED_ICON_URL.equals(this.pointTypeString) || KMLGenerator.WATER_POINT_FUNCTIONING_YELLOW_ICON_URL.equals(this.pointTypeString)) {
                this.setPointType(AccessPoint.AccessPointType.WATER_POINT);
            }
        }
        if (req.getParameter(STANDARD_TYPE) != null) {
            if (req.getParameter(STANDARD_TYPE).equals(Standard.StandardType.WaterPointLevelOfService.toString())) {
                this.setStandardType(Standard.StandardType.WaterPointLevelOfService);
            } else if (req.getParameter(STANDARD_TYPE).equals(Standard.StandardType.WaterPointSustainability.toString())) {
                this.setStandardType(Standard.StandardType.WaterPointSustainability);
            }
        }
        try {
            if (req.getParameter(NEED_DETAILS_PARM) != null) {
                this.setNeedDetailsFlag(new Boolean(req.getParameter(NEED_DETAILS_PARM).toLowerCase()));
            }
        }
        catch (Exception ex) {
            this.addError(new RestError("5001", "Missing mandatory parameter", NEED_DETAILS_PARM));
        }
    }

    @Override
    protected void populateErrors() {
        if (this.country == null && super.getAction() == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", COUNTRY_PARAM));
        }
    }

    public void setNeedDetailsFlag(Boolean needDetailsFlag) {
        this.needDetailsFlag = needDetailsFlag;
    }

    public Boolean getNeedDetailsFlag() {
        return this.needDetailsFlag;
    }

    public void setPointType(AccessPoint.AccessPointType pointType) {
        this.pointType = pointType;
    }

    public AccessPoint.AccessPointType getPointType() {
        return this.pointType;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getCommunityCode() {
        return this.communityCode;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getCacheKey() {
        String key = this.getAction();
        if (key == null) {
            key = LIST_PLACEMARK;
            key = key + this.country + (this.display != null ? this.display : "") + (this.pointTypeString != null ? this.pointTypeString : "") + (this.getCursor() != null ? this.getCursor() : "");
            if (this.getOrg() != null) {
                key = key + key + ":org=" + this.getOrg();
            }
        } else if (GET_AP_DETAILS_ACTION.equals(key)) {
            key = key + "-" + this.communityCode + (this.display != null ? this.display : "") + (this.pointTypeString != null ? this.pointTypeString : "");
        } else if (LIST_BOUNDING_BOX_ACTION.equals(key)) {
            key = key + "/" + this.getLat1() + "/" + this.getLat2() + "/" + this.getPointTypeString();
            if (this.getCursor() != null) {
                key = key + "/" + this.getCursor();
            }
        }
        return key;
    }

    public void setIgnoreCache(Boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
    }

    public Boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public String getPointTypeString() {
        return this.pointTypeString;
    }

    public void setPointTypeString(String pointTypeString) {
        this.pointTypeString = pointTypeString;
    }

    public void setStandardType(Standard.StandardType standardType) {
        this.standardType = standardType;
    }

    public Standard.StandardType getStandardType() {
        return this.standardType;
    }
}

