/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.dao.ReportDao;
import org.akvo.flow.domain.persistent.Report;
import org.akvo.flow.rest.dto.ReportDto;
import org.akvo.flow.rest.dto.ReportPayload;
import org.akvo.flow.servlet.ReportServlet;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/reports"})
public class ReportRestService {
    private static final Logger log = Logger.getLogger(ReportRestService.class.getName());
    private final String[] doNotCopy = new String[]{"createdDateTime", "lastUpdateDateTime"};
    private ReportDao reportDao = new ReportDao();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewReport(@RequestBody ReportPayload payLoad, @RequestHeader(value="Host", required=false) String host) {
        ReportDto reportDto = payLoad.getReport();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ReportDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (reportDto != null) {
            Report r = new Report();
            BeanUtils.copyProperties((Object)reportDto, (Object)r, (String[])this.doNotCopy);
            r.setUser((Long)SecurityContextHolder.getContext().getAuthentication().getCredentials());
            r.setState("QUEUED");
            r = this.reportDao.save(r);
            String baseUrl = null;
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (request == null) {
                log.severe("Request details not available!");
                baseUrl = "https://www.example.com";
            } else {
                baseUrl = request.getScheme() + "://" + host;
            }
            ReportServlet.queueStart(baseUrl, r);
            dto = new ReportDto();
            BeanUtils.copyProperties((Object)r, (Object)dto);
            dto.setKeyId(r.getKey().getId());
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("report", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listMyReports() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<ReportDto> results = new ArrayList<ReportDto>();
        List<Report> reports = this.reportDao.listAllByCurrentUser();
        if (reports != null) {
            for (Report r : reports) {
                ReportDto dto = new ReportDto();
                BeanUtils.copyProperties((Object)r, (Object)dto);
                dto.setKeyId(r.getKey().getId());
                results.add(dto);
            }
        }
        response.put("reports", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, ReportDto> findReport(@PathVariable(value="id") Long id) {
        HashMap<String, ReportDto> response = new HashMap<String, ReportDto>();
        Report r = (Report)this.reportDao.getByKey(id);
        ReportDto dto = null;
        if (r != null) {
            dto = new ReportDto();
            BeanUtils.copyProperties((Object)r, (Object)dto);
            dto.setKeyId(r.getKey().getId());
        }
        response.put("report", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteReportById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        Report r = (Report)this.reportDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (r != null) {
            this.reportDao.delete(r);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingReport(@RequestBody ReportPayload payLoad) {
        Report r;
        Long keyId;
        ReportDto reportDto = payLoad.getReport();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ReportDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (reportDto != null && (keyId = reportDto.getKeyId()) != null && (r = (Report)this.reportDao.getByKey(keyId)) != null) {
            r.setState(reportDto.getState());
            r.setMessage(reportDto.getMessage());
            r = this.reportDao.save(r);
            dto = new ReportDto();
            BeanUtils.copyProperties((Object)r, (Object)dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("report", dto);
        return response;
    }
}

