/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.standards.domain.LOSScoreToStatusMapping;
import com.gallatinsystems.standards.domain.Standard;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.memcache.MemcacheService;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheManager;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.gwt.client.location.PlacemarkDto;
import org.waterforpeople.mapping.app.web.KMLGenerator;
import org.waterforpeople.mapping.app.web.dto.PlacemarkRestRequest;
import org.waterforpeople.mapping.app.web.dto.PlacemarkRestResponse;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.domain.AccessPoint;

public class PlacemarkServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -9031594440737716966L;
    private static final Logger log = Logger.getLogger(PlacemarkServlet.class.getName());
    private static final String AP_DOMAIN = "accessPoint";
    private static final int CACHE_EXPIRY_DEFAULT = 3600;
    private static final String CACHE_EXP_PROP = "cacheExpirySeconds";
    private KMLGenerator kmlGen = new KMLGenerator();
    private Cache cache;
    private AccessPointDao apDao = new AccessPointDao();
    private SurveyedLocaleDao localeDao = new SurveyedLocaleDao();
    private int cacheExpirySec = 3600;

    public PlacemarkServlet() {
        try {
            CacheFactory cacheFactory = CacheManager.getInstance().getCacheFactory();
            HashMap<String, Constable> configMap = new HashMap<String, Constable>();
            String cacheExpString = PropertyUtil.getProperty(CACHE_EXP_PROP);
            if (cacheExpString != null) {
                try {
                    this.cacheExpirySec = Integer.parseInt(cacheExpString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cacheExpirySec <= 0) {
                this.cacheExpirySec = 3600;
            }
            configMap.put("com.google.appengine.api.memcache.jsr107cache.EXPIRATION_DELTA", Integer.valueOf(this.cacheExpirySec));
            configMap.put((String)MemcacheService.SetPolicy.SET_ALWAYS, Boolean.valueOf(true));
            this.cache = cacheFactory.createCache(configMap);
        }
        catch (CacheException e) {
            log.log(Level.SEVERE, "Could not initialize cache", e);
        }
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        PlacemarkRestRequest restRequest = new PlacemarkRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        List<BaseDomain> results;
        PlacemarkRestRequest piReq = (PlacemarkRestRequest)req;
        if (this.cache != null && !piReq.getIgnoreCache().booleanValue()) {
            PlacemarkRestResponse cachedResponse = null;
            try {
                log.log(Level.INFO, "Checking Cache for: " + piReq.getCacheKey());
                cachedResponse = (PlacemarkRestResponse)this.cache.get((Object)piReq.getCacheKey());
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Could not look up data in cache", t);
            }
            if (cachedResponse != null) {
                return cachedResponse;
            }
        }
        int desiredResults = 20;
        if (piReq.getDesiredResults() > 20) {
            desiredResults = piReq.getDesiredResults() > 500 ? 500 : piReq.getDesiredResults();
        }
        String display = null;
        if (piReq.getDisplay() != null) {
            display = piReq.getDisplay();
        }
        PlacemarkRestResponse response = null;
        Standard.StandardType standardType = piReq.getStandardType();
        if (piReq.getDomain() == null || AP_DOMAIN.equalsIgnoreCase(piReq.getDomain())) {
            if (piReq.getAction() != null && "getAPDetails".equals(piReq.getAction())) {
                ArrayList<AccessPoint> apList = new ArrayList<AccessPoint>();
                if (piReq.getCommunityCode() != null && piReq.getCommunityCode().trim().length() > 0) {
                    AccessPoint ap = this.apDao.findAccessPoint(piReq.getCommunityCode(), piReq.getPointType());
                    if (ap != null) {
                        apList.add(ap);
                    } else {
                        log.log(Level.SEVERE, "PlacemarkServlet.handleRequest getAPDetails didn't find AP for CommunityCode : " + piReq.getCommunityCode() + " piReq.getPointType: " + piReq.getPointTypeString());
                    }
                }
                response = (PlacemarkRestResponse)this.convertToResponse(apList, true, null, null, piReq.getDisplay(), standardType);
            } else if (piReq.getAction() == null) {
                if (piReq.getOrg() != null) {
                    results = this.apDao.searchAccessPoints(piReq.getCountry(), null, null, null, null, null, null, null, piReq.getOrg(), "collectionDate", "asc", desiredResults, piReq.getCursor());
                    response = (PlacemarkRestResponse)this.convertToResponse(results, piReq.getNeedDetailsFlag(), AccessPointDao.getCursor(results), piReq.getCursor(), display, standardType);
                } else if (piReq.getSubLevel() != null) {
                    results = this.apDao.listBySubLevel(piReq.getCountry(), piReq.getSubLevel(), piReq.getSubLevelValue(), piReq.getCursor(), AccessPoint.AccessPointType.WATER_POINT, desiredResults);
                    response = (PlacemarkRestResponse)this.convertToResponse(results, piReq.getNeedDetailsFlag(), AccessPointDao.getCursor(results), piReq.getCursor(), display, standardType);
                } else {
                    results = this.apDao.searchAccessPoints(piReq.getCountry(), null, null, null, null, null, null, null, null, null, desiredResults, piReq.getCursor());
                    if (piReq.getDisplay() != null) {
                        display = piReq.getDisplay();
                    }
                    response = (PlacemarkRestResponse)this.convertToResponse(results, piReq.getNeedDetailsFlag(), AccessPointDao.getCursor(results), piReq.getCursor(), display, standardType);
                }
            } else if (piReq.getAction().equals("listByBoundingBox") && piReq.getLat1() != null) {
                results = this.apDao.listAccessPointsByBoundingBox(piReq.getPointType(), piReq.getLat1(), piReq.getLat2(), piReq.getLong1(), piReq.getLong2(), piReq.getCursor(), desiredResults);
                response = (PlacemarkRestResponse)this.convertToResponse(results, piReq.getNeedDetailsFlag(), AccessPointDao.getCursor(results), piReq.getCursor(), piReq.getDisplay(), standardType);
            }
        } else if (piReq.getAction() != null && "getAPDetails".equals(piReq.getAction())) {
            List<SurveyedLocale> localeList = this.localeDao.listLocalesByCode(piReq.getCommunityCode(), true);
            response = (PlacemarkRestResponse)this.convertLocaleToResponse(localeList, true, null, null, piReq.getDisplay());
        } else if ("listByBoundingBox".equals(piReq.getAction()) && piReq.getLat1() != null) {
            results = this.localeDao.listLocalesByCoordinates(piReq.getPointTypeString(), piReq.getLat1(), piReq.getLat2(), piReq.getLong1(), piReq.getLong2(), piReq.getCursor(), desiredResults);
            response = (PlacemarkRestResponse)this.convertLocaleToResponse(results, piReq.getNeedDetailsFlag(), SurveyedLocaleDao.getCursor(results), piReq.getCursor(), piReq.getDisplay());
        } else {
            results = this.localeDao.listBySubLevel(piReq.getCountry(), null, null, piReq.getPointTypeString(), null, piReq.getCursor(), desiredResults);
            response = (PlacemarkRestResponse)this.convertLocaleToResponse(results, piReq.getNeedDetailsFlag(), SurveyedLocaleDao.getCursor(results), piReq.getCursor(), display);
        }
        if (response != null && this.cache != null) {
            try {
                this.cache.put((Object)piReq.getCacheKey(), response);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Could not cache results", t);
            }
        }
        return response;
    }

    private RestResponse convertToResponse(List<AccessPoint> apList, Boolean needDetailsFlag, String cursor, String oldCursor, String display, Standard.StandardType standardType) {
        PlacemarkRestResponse resp = new PlacemarkRestResponse();
        if (needDetailsFlag == null) {
            needDetailsFlag = true;
        }
        if (apList != null) {
            ArrayList<PlacemarkDto> dtoList = new ArrayList<PlacemarkDto>();
            for (AccessPoint ap : apList) {
                PlacemarkDto pdto;
                if (!ap.getPointType().equals((Object)AccessPoint.AccessPointType.SANITATION_POINT) && (pdto = this.marshallDomainToDto(ap, needDetailsFlag, display, standardType)) != null) {
                    dtoList.add(pdto);
                }
                resp.setPlacemarks(dtoList);
            }
        }
        if (cursor != null) {
            if (oldCursor == null || !cursor.equals(oldCursor)) {
                resp.setCursor(cursor);
            }
        } else {
            resp.setCursor(null);
        }
        return resp;
    }

    private RestResponse convertLocaleToResponse(List<SurveyedLocale> localeList, Boolean needDetailsFlag, String cursor, String oldCursor, String display) {
        PlacemarkRestResponse resp = new PlacemarkRestResponse();
        if (needDetailsFlag == null) {
            needDetailsFlag = true;
        }
        if (localeList != null) {
            ArrayList<PlacemarkDto> dtoList = new ArrayList<PlacemarkDto>();
            for (SurveyedLocale ap : localeList) {
                dtoList.add(this.marshallDomainToDto(ap, needDetailsFlag, display));
            }
            resp.setPlacemarks(dtoList);
        }
        if (cursor != null) {
            if (oldCursor == null || !cursor.equals(oldCursor)) {
                resp.setCursor(cursor);
            }
        } else {
            resp.setCursor(null);
        }
        return resp;
    }

    private PlacemarkDto marshallDomainToDto(SurveyedLocale ap, Boolean needDetailsFlag, String display) {
        PlacemarkDto pdto = new PlacemarkDto();
        pdto.setPinStyle(KMLGenerator.encodePinStyle(ap.getLocaleType(), ap.getCurrentStatus()));
        pdto.setIconUrl(KMLGenerator.getMarkerImageUrl(ap.getLocaleType(), ap.getCurrentStatus()));
        if (ap.getLocaleType() == null) {
            pdto.setMarkType(AccessPoint.AccessPointType.WATER_POINT.toString());
        } else {
            pdto.setMarkType(ap.getLocaleType());
        }
        pdto.setLatitude(ap.getLatitude());
        pdto.setLongitude(ap.getLongitude());
        pdto.setCommunityCode(ap.getIdentifier());
        pdto.setCollectionDate(ap.getLastUpdateDateTime());
        if (needDetailsFlag.booleanValue()) {
            String placemarkString = null;
            try {
                placemarkString = this.kmlGen.bindPlacemark(ap, "localePlacemarkExternal.vm", display);
                pdto.setPlacemarkContents(placemarkString);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not bind placemarks", e);
            }
        }
        return pdto;
    }

    private PlacemarkDto marshallDomainToDto(AccessPoint ap, Boolean needDetailsFlag, String display, Standard.StandardType standardType) {
        PlacemarkDto pdto = new PlacemarkDto();
        if (standardType != null) {
            KMLGenerator kmlGen = new KMLGenerator();
            LOSScoreToStatusMapping losItem = kmlGen.encodePinStyle(ap.getKey(), standardType);
            pdto.setPinStyle(losItem.getIconStyle());
            pdto.setIconUrl(losItem.getIconLargeUrl());
        } else {
            pdto.setPinStyle(KMLGenerator.encodePinStyle(ap.getPointType(), ap.getPointStatus()));
            pdto.setIconUrl(this.getUrlFromStatus(ap.getPointStatus(), ap.getPointType()));
        }
        pdto.setLatitude(ap.getLatitude());
        pdto.setLongitude(ap.getLongitude());
        pdto.setCommunityCode(ap.getCommunityCode());
        pdto.setMarkType(ap.getPointType().toString());
        pdto.setCollectionDate(ap.getCollectionDate());
        if (needDetailsFlag.booleanValue()) {
            String placemarkString = null;
            try {
                placemarkString = this.kmlGen.bindPlacemark(ap, "placemarkExternalMap.vm", display, standardType);
                pdto.setPlacemarkContents(placemarkString);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not bind placemarks", e);
            }
        }
        return pdto;
    }

    private String getUrlFromStatus(AccessPoint.Status status, AccessPoint.AccessPointType pointType) {
        if (pointType.equals((Object)AccessPoint.AccessPointType.WATER_POINT) && status == null) {
            return KMLGenerator.WATER_POINT_FUNCTIONING_BLACK_ICON_URL;
        }
        if (AccessPoint.AccessPointType.WATER_POINT.equals((Object)pointType)) {
            if (status != null) {
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
                    return KMLGenerator.WATER_POINT_FUNCTIONING_GREEN_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK) || status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
                    return KMLGenerator.WATER_POINT_FUNCTIONING_YELLOW_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.BROKEN_DOWN)) {
                    return KMLGenerator.WATER_POINT_FUNCTIONING_RED_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
                    return KMLGenerator.WATER_POINT_FUNCTIONING_BLACK_ICON_URL;
                }
                return KMLGenerator.WATER_POINT_FUNCTIONING_BLACK_ICON_URL;
            }
            return KMLGenerator.WATER_POINT_FUNCTIONING_BLACK_ICON_URL;
        }
        if (AccessPoint.AccessPointType.PUBLIC_INSTITUTION.equals((Object)pointType)) {
            if (status != null) {
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
                    return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_GREEN_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK) || status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
                    return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.BROKEN_DOWN)) {
                    return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_RED_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
                    return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
                }
                return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
            }
            return KMLGenerator.PUBLIC_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
        }
        if (AccessPoint.AccessPointType.SCHOOL.equals((Object)pointType)) {
            if (status != null) {
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_HIGH)) {
                    return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_GREEN_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.FUNCTIONING_OK) || status.equals((Object)AccessPoint.Status.FUNCTIONING_WITH_PROBLEMS)) {
                    return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_YELLOW_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.BROKEN_DOWN)) {
                    return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_RED_ICON_URL;
                }
                if (status.equals((Object)AccessPoint.Status.NO_IMPROVED_SYSTEM)) {
                    return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
                }
                return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
            }
            return KMLGenerator.SCHOOL_INSTITUTION_FUNCTIONING_BLACK_ICON_URL;
        }
        return null;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        PlacemarkRestResponse piResp = (PlacemarkRestResponse)resp;
        JSONObject result = new JSONObject((Object)piResp);
        this.getResponse().getWriter().println(result.toString());
    }
}

