/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.PlacemarkDto;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;

@Controller
@RequestMapping(value={"/placemarks"})
public class PlacemarkRestService {
    final int LIMIT_PLACEMARK_POINTS = 2000;
    private static final Logger log = Logger.getLogger(PlacemarkRestService.class.getName());
    private SurveyedLocaleDao localeDao = new SurveyedLocaleDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listPlaceMarks(@RequestParam(value="bbString", defaultValue="") String boundingBoxString, @RequestParam(value="gcLevel", defaultValue="") Integer gcLevel) {
        log.log(Level.FINE, "received request for: " + boundingBoxString + ", " + gcLevel);
        List<String> geocells = Arrays.asList(boundingBoxString.split(","));
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<PlacemarkDto> placemarkList = new ArrayList<PlacemarkDto>();
        ArrayList<SurveyedLocale> slList = new ArrayList<SurveyedLocale>();
        if (this.isAuthorizedUser()) {
            slList.addAll(this.listAllDataPoints(geocells));
        } else {
            slList.addAll(this.listOnlyPublicDataPoints(geocells));
        }
        if (slList != null) {
            for (SurveyedLocale sl : slList) {
                placemarkList.add(this.marshallDomainToDto(sl));
            }
        }
        response.put("placemarks", placemarkList);
        return response;
    }

    private boolean isAuthorizedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Collection auths = authentication.getAuthorities();
        return auths.contains((Object)AppRole.USER) || auths.contains((Object)AppRole.ADMIN) || auths.contains((Object)AppRole.SUPER_ADMIN);
    }

    private List<SurveyedLocale> listAllDataPoints(List<String> geocells) {
        return this.localeDao.listLocalesByGeocell(geocells, 2000);
    }

    private List<SurveyedLocale> listOnlyPublicDataPoints(List<String> geocells) {
        return this.localeDao.listPublicLocalesByGeocell(geocells, 2000);
    }

    private PlacemarkDto marshallDomainToDto(SurveyedLocale sl) {
        PlacemarkDto dto = new PlacemarkDto();
        dto.setLatitude(sl.getLatitude());
        dto.setLongitude(sl.getLongitude());
        dto.setCount(1);
        dto.setDetailsId(sl.getKey().getId());
        dto.setLevel(0);
        dto.setSurveyId(sl.getCreationSurveyId());
        dto.setCollectionDate(sl.getLastSurveyedDate());
        dto.setKeyId(sl.getKey().getId() * 2L);
        return dto;
    }
}

