/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.helper.AccessPointHelper;

public class ScoreProcessor
extends HttpServlet {
    public static final String ASYNC_TASK_TIMEOUT = "asyncTaskTimeout";
    private static final long serialVersionUID = 5500271297082259592L;
    public static final String OBJECT_TASK_URL = "/app_worker/scoreprocessor";
    public static final String ACCESSPOINT_QUEUE_NAME = "accesspointscorequeue";
    private static final Logger log = Logger.getLogger(ScoreProcessor.class.getName());
    static Integer executionCount = 0;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.scorePoints(req);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.scorePoints(req);
    }

    private void scorePoints(HttpServletRequest req) {
        Integer timeoutSeconds = Integer.parseInt(PropertyUtil.getProperty(ASYNC_TASK_TIMEOUT));
        Integer n = executionCount;
        Integer n2 = executionCount = Integer.valueOf(executionCount + 1);
        log.info("Execution Count: " + executionCount);
        int scored_count = 0;
        Integer FETCH_NUM_RECORDS = 10;
        boolean is_finished = false;
        AccessPointHelper aph = new AccessPointHelper();
        AccessPointDao apDao = new AccessPointDao();
        DatastoreService dss = DatastoreServiceFactory.getDatastoreService();
        long start = System.currentTimeMillis();
        Cursor endCursor = null;
        block2: while (System.currentTimeMillis() - start < (long)timeoutSeconds.intValue()) {
            Query query = new Query("AccessPoint");
            query.setKeysOnly();
            ArrayList<Key> keys = new ArrayList<Key>();
            String cursor = req.getParameter("cursor");
            PreparedQuery pquery = dss.prepare(query);
            cursor = cursor.trim();
            FetchOptions fetchOptions = null;
            if (cursor != null && !cursor.equalsIgnoreCase("null") && !cursor.equals("")) {
                Cursor c = Cursor.fromWebSafeString((String)cursor);
                fetchOptions = FetchOptions.Builder.withLimit((int)FETCH_NUM_RECORDS).startCursor(c);
            } else {
                fetchOptions = FetchOptions.Builder.withLimit((int)FETCH_NUM_RECORDS);
            }
            QueryResultIterator list = pquery.asQueryResultIterator(fetchOptions);
            while (list.hasNext()) {
                keys.add(((Entity)list.next()).getKey());
            }
            endCursor = list.getCursor();
            keys.trimToSize();
            if (keys.size() == 0) {
                is_finished = true;
                break;
            }
            while (System.currentTimeMillis() - start < (long)timeoutSeconds.intValue()) {
                try {
                    Key apKey = (Key)keys.get(scored_count);
                    AccessPoint ap = (AccessPoint)apDao.getByKey(apKey);
                    aph.scoreAccessPointNew(ap);
                    log.info("Scored :  " + ap.getKeyString());
                    int n3 = ++scored_count;
                    ++scored_count;
                    if (keys.size() - 1 != n3) continue;
                    continue block2;
                }
                catch (Throwable ignore) {
                }
            }
        }
        if (is_finished) {
            System.err.println("*** score job for AccessPoint is completed.");
        } else {
            String taskCount = req.getParameter("taskCount");
            String tcs = taskCount;
            Integer taskcount = tcs == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(tcs) + 1);
            Queue deleteQueue = QueueFactory.getQueue((String)ACCESSPOINT_QUEUE_NAME);
            deleteQueue.add(TaskOptions.Builder.withUrl((String)OBJECT_TASK_URL).param("taskCount", taskcount.toString()).param("cursor", endCursor.toWebSafeString()));
            System.err.println("*** finished scoring " + scored_count + " APs");
            System.err.println("*** score task # " + taskcount + " for AccessPoint is queued.");
        }
    }
}

