/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.gis.location.GeoLocationServiceGeonamesImpl;
import com.gallatinsystems.gis.location.GeoPlace;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.analytics.dao.SurveyInstanceSummaryDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.GeoCoordinates;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyInstanceSummarizer
implements DataSummarizer {
    private static Logger logger = Logger.getLogger(SurveyInstanceSummarizer.class.getName());
    private static final String GEO_TYPE = "GEO";
    private SurveyInstanceDAO instanceDao = new SurveyInstanceDAO();

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        boolean success = false;
        if (key != null) {
            SurveyInstance instance = (SurveyInstance)this.instanceDao.getByKey(new Long(key));
            List<QuestionAnswerStore> qasList = this.instanceDao.listQuestionAnswerStoreByType(new Long(key), GEO_TYPE);
            if (qasList != null) {
                GeoCoordinates geoC = null;
                for (QuestionAnswerStore q : qasList) {
                    if (q.getValue() != null && q.getValue().trim().length() > 0 && (geoC = GeoCoordinates.extractGeoCoordinate(q.getValue())) != null) break;
                }
                if (geoC != null) {
                    GeoLocationServiceGeonamesImpl gisService = new GeoLocationServiceGeonamesImpl();
                    GeoPlace gp = gisService.findDetailedGeoPlace(geoC.getLatitude().toString(), geoC.getLongitude().toString());
                    if (gp != null) {
                        SurveyInstanceSummaryDao.incrementCount(gp.getSub1(), gp.getCountryCode(), instance.getCollectionDate(), 1);
                        success = true;
                    }
                } else {
                    logger.log(Level.INFO, "Instance does not have a geo question: " + instance.getKey().getId());
                    success = true;
                }
            }
            if (!success) {
                logger.log(Level.SEVERE, "Couldn't find community for instance. Was the community saved correctly? Instance id: " + key);
            }
        }
        return true;
    }

    @Override
    public String getCursor() {
        return null;
    }
}

