/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.CascadeNode;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class CascadeNodeDao
extends BaseDAO<CascadeNode> {
    private static final Logger log = Logger.getLogger(SurveyGroupDAO.class.getName());

    public CascadeNodeDao() {
        super(CascadeNode.class);
    }

    public List<CascadeNode> listCascadeNodesByResource(Long cascadeResourceId) {
        List<CascadeNode> cnList = this.listByProperty("cascadeResourceId", (Object)cascadeResourceId, "Long", "name", "asc");
        return cnList;
    }

    public List<CascadeNode> listCascadeNodesByResourceAndParentId(Long cascadeResourceId, Long parentNodeId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(CascadeNode.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("cascadeResourceId", filterString, paramString, "Long", cascadeResourceId, paramMap);
        this.appendNonNullParam("parentNodeId", filterString, paramString, "Long", parentNodeId, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public void deleteRecursive(Long cascadeResourceId, Long nodeId) {
        CascadeNode cr = (CascadeNode)this.getByKey(nodeId);
        if (cr == null) {
            return;
        }
        try {
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "deleteCascadeNodes").param("cascadeResourceId", cascadeResourceId.toString()).param("parentNodeId", nodeId.toString());
            Queue queue = QueueFactory.getQueue((String)"background-processing");
            queue.add(options);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.format("Error scheduling Cascade Node deletion - cascadeResourceId: %s - parentNodeId: %s", cascadeResourceId, nodeId), e);
        }
        this.delete(cr);
    }

    public List<CascadeNode> listByName(Long cascadeResourceId, List<String> cascadeNodeNames) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = "cascadeResourceId == :p1 && :p2.contains(name)";
        Query query = pm.newQuery(CascadeNode.class, queryString);
        return (List)query.execute((Object)cascadeResourceId, cascadeNodeNames);
    }
}

