/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.standards.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.standards.dao.DistanceStandardDao;
import com.gallatinsystems.standards.dao.StandardDao;
import com.gallatinsystems.standards.domain.CompoundStandard;
import com.gallatinsystems.standards.domain.DistanceStandard;
import com.gallatinsystems.standards.domain.Standard;
import com.gallatinsystems.standards.domain.StandardDef;
import com.google.appengine.api.datastore.Key;
import java.util.ArrayList;
import java.util.List;

public class CompoundStandardDao
extends BaseDAO<CompoundStandard> {
    public CompoundStandardDao() {
        super(CompoundStandard.class);
    }

    public List<CompoundStandard> listByChildStandard(Long id) {
        List csListLeft = super.listByProperty("standardIdLeft", id, "Long");
        List csListRight = super.listByProperty("standardIdRight", id, "Long");
        ArrayList<CompoundStandard> csList = new ArrayList<CompoundStandard>();
        if (csListLeft != null && csListLeft.size() > 0) {
            csList.addAll(csListLeft);
        }
        if (csListRight != null && csListRight.size() > 0) {
            csList.addAll(csListRight);
        }
        return csList;
    }

    @Override
    public void delete(Long id) {
        CompoundStandard cs = this.getByKey(id);
        if (cs != null) {
            Standard s;
            StandardDao sDao;
            DistanceStandard ds;
            DistanceStandardDao dsDao = new DistanceStandardDao();
            if (dsDao.getByKey(cs.getStandardIdLeft()) != null) {
                ds = (DistanceStandard)dsDao.getByKey(cs.getStandardIdLeft());
                ds.setPartOfCompoundRule(false);
                dsDao.save(ds);
            }
            if (dsDao.getByKey(cs.getStandardIdRight()) != null) {
                ds = (DistanceStandard)dsDao.getByKey(cs.getStandardIdRight());
                ds.setPartOfCompoundRule(false);
                dsDao.save(ds);
            }
            if ((sDao = new StandardDao()).getByKey(cs.getStandardIdLeft()) != null) {
                s = (Standard)sDao.getByKey(cs.getStandardIdLeft());
                s.setPartOfCompoundRule(false);
                sDao.save(s);
            }
            if (sDao.getByKey(cs.getStandardIdRight()) != null) {
                s = (Standard)sDao.getByKey(cs.getStandardIdRight());
                s.setPartOfCompoundRule(false);
                sDao.save(s);
            }
        }
    }

    @Override
    public CompoundStandard save(CompoundStandard item) {
        DistanceStandardDao dsDao;
        DistanceStandard ds;
        StandardDao ssdao = new StandardDao();
        if (item.getStandardIdLeft() != null) {
            if (item.getStandardLeftRuleType().equals((Object)CompoundStandard.RuleType.NONDISTANCE)) {
                Standard left = (Standard)ssdao.getByKey(item.getStandardIdLeft());
                item.setStandardLeft(left);
                item.setStandardIdLeft(left.getKey().getId());
                left.setPartOfCompoundRule(true);
                ssdao.save(left);
            } else if (item.getStandardLeftRuleType().equals((Object)CompoundStandard.RuleType.DISTANCE) && (ds = (DistanceStandard)(dsDao = new DistanceStandardDao()).getByKey(item.getStandardIdLeft())) != null) {
                ds.setPartOfCompoundRule(true);
                item.setStandardLeft(ds);
                item.setStandardIdLeft(ds.getKey().getId());
                dsDao.save(ds);
            }
        }
        if (item.getStandardIdRight() != null) {
            if (item.getStandardRightRuleType().equals((Object)CompoundStandard.RuleType.NONDISTANCE)) {
                Standard right = (Standard)ssdao.getByKey(item.getStandardIdRight());
                item.setStandardRight(right);
                right.setPartOfCompoundRule(true);
                item.setStandardIdRight(right.getKey().getId());
                ssdao.save(right);
            } else if (item.getStandardRightRuleType().equals((Object)CompoundStandard.RuleType.DISTANCE) && (ds = (DistanceStandard)(dsDao = new DistanceStandardDao()).getByKey(item.getStandardIdRight())) != null) {
                ds.setPartOfCompoundRule(true);
                item.setStandardRight(ds);
                item.setStandardIdRight(ds.getKey().getId());
                dsDao.save(ds);
            }
        }
        return super.save(item);
    }

    public List<CompoundStandard> listByType(Standard.StandardType type) {
        List<CompoundStandard> csList = super.listByProperty("standardType", (Object)type, "String");
        StandardDao ssDao = new StandardDao();
        for (CompoundStandard item : csList) {
            DistanceStandard rightDs;
            DistanceStandardDao dsDao;
            if (item.getStandardIdLeft() != null) {
                DistanceStandard leftDs;
                if (item.getStandardLeftRuleType().equals((Object)CompoundStandard.RuleType.NONDISTANCE)) {
                    Standard left = (Standard)ssDao.getByKey(item.getStandardIdLeft());
                    if (left != null) {
                        item.setStandardLeft(left);
                    }
                } else if (item.getStandardLeftRuleType().equals((Object)CompoundStandard.RuleType.DISTANCE) && (leftDs = (DistanceStandard)(dsDao = new DistanceStandardDao()).getByKey(item.getStandardIdLeft())) != null) {
                    item.setStandardLeft(leftDs);
                }
            }
            if (item.getStandardIdRight() == null) continue;
            if (item.getStandardRightRuleType().equals((Object)CompoundStandard.RuleType.NONDISTANCE)) {
                Standard right = (Standard)ssDao.getByKey(item.getStandardIdRight());
                if (right == null) continue;
                item.setStandardRight(right);
                continue;
            }
            if (!item.getStandardRightRuleType().equals((Object)CompoundStandard.RuleType.DISTANCE) || (rightDs = (DistanceStandard)(dsDao = new DistanceStandardDao()).getByKey(item.getStandardIdRight())) == null) continue;
            item.setStandardRight(rightDs);
        }
        return csList;
    }

    @Override
    public CompoundStandard getByKey(Long id) {
        CompoundStandard item = (CompoundStandard)super.getByKey(id);
        StandardDao ssDao = new StandardDao();
        item.setStandardLeft((StandardDef)ssDao.getByKey(item.getStandardIdLeft()));
        item.setStandardRight((StandardDef)ssDao.getByKey(item.getStandardIdRight()));
        return item;
    }

    @Override
    public CompoundStandard getByKey(Key key) {
        return this.getByKey(key.getId());
    }
}

