/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.google.gdata.util.common.util.Base64;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MD5Util {
    private static final Logger log = Logger.getLogger(MD5Util.class.getName());

    public static byte[] md5(byte[] arr) {
        try {
            MessageDigest complete = MessageDigest.getInstance("MD5");
            complete.update(arr);
            return complete.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, "Could not generate checksum", e);
            return null;
        }
    }

    public static String generateChecksum(byte[] arr) {
        byte[] digest = MD5Util.md5(arr);
        if (digest != null) {
            return MD5Util.toHex(digest);
        }
        return null;
    }

    public static String toHex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte b : data) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static String generateHMAC(String content, String privateKey) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(privateKey.getBytes(), mac.getAlgorithm());
            mac.init(secret);
            byte[] digest = mac.doFinal(content.getBytes());
            return Base64.encode((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

