/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.dao.ReportDao;
import org.akvo.flow.domain.persistent.Report;
import org.akvo.flow.rest.dto.ReportDto;
import org.akvo.flow.rest.dto.ReportPayload;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/reports"})
public class ReportRestService {
    private final String[] doNotCopy = new String[]{"user", "createdDateTime", "lastUpdateDateTime"};
    private ReportDao reportDao = new ReportDao();
    private UserDao userDao = new UserDao();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewReport(@RequestBody ReportPayload payLoad) {
        User user;
        ReportDto reportDto = payLoad.getReport();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ReportDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (reportDto != null && (user = this.userDao.findUserByEmail(reportDto.getUser())) != null) {
            Report r = new Report();
            BeanUtils.copyProperties((Object)reportDto, (Object)r, (String[])this.doNotCopy);
            r.setUser(user.getKey().getId());
            r = this.reportDao.save(r);
            dto = new ReportDto();
            DtoMarshaller.copyToDto(r, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("report", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listMyReports() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<ReportDto> results = new ArrayList<ReportDto>();
        List<Report> reports = this.reportDao.listAllByCurrentUser();
        if (reports != null) {
            for (Report r : reports) {
                ReportDto dto = new ReportDto();
                DtoMarshaller.copyToDto(r, dto);
                results.add(dto);
            }
        }
        response.put("reports", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, ReportDto> findReport(@PathVariable(value="id") Long id) {
        HashMap<String, ReportDto> response = new HashMap<String, ReportDto>();
        Report qo = (Report)this.reportDao.getByKey(id);
        ReportDto dto = null;
        if (qo != null) {
            dto = new ReportDto();
            DtoMarshaller.copyToDto(qo, dto);
        }
        response.put("report", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteReportById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        Report qo = (Report)this.reportDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (qo != null) {
            this.reportDao.delete(qo);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingReport(@RequestBody ReportPayload payLoad) {
        Report qo;
        Long keyId;
        ReportDto reportDto = payLoad.getReport();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ReportDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (reportDto != null && (keyId = reportDto.getKeyId()) != null && (qo = (Report)this.reportDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)reportDto, (Object)qo, (String[])this.doNotCopy);
            qo = this.reportDao.save(qo);
            dto = new ReportDto();
            DtoMarshaller.copyToDto(qo, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("report", dto);
        return response;
    }
}

