/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.security.authorization.utility;

import com.gallatinsystems.common.util.PropertyUtil;
import com.google.gdata.client.http.AuthSubUtil;
import com.google.gdata.util.AuthenticationException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TokenUtility {
    private static final Logger log = Logger.getLogger(TokenUtility.class.getName());

    public String generateSessionTokenFromSingleUse(String singleUseToken) throws AuthenticationException, IOException, GeneralSecurityException {
        PrivateKey pk = this.getPrivateKey();
        if (pk != null) {
            log.log(Level.INFO, "Got PK");
        }
        return AuthSubUtil.exchangeForSessionToken((String)singleUseToken, (PrivateKey)pk);
    }

    public PrivateKey getPrivateKey() throws IOException, GeneralSecurityException {
        Properties props = System.getProperties();
        String storepassword = props.getProperty("storepass");
        String alias = props.getProperty("alias");
        String keypassword = props.getProperty("keypass");
        return AuthSubUtil.getPrivateKeyFromKeystore((String)PropertyUtil.getProperty("keystore"), (String)storepassword, (String)alias, (String)keypassword);
    }
}

