/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.beoui.geocell.GeocellManager;
import com.beoui.geocell.model.Point;
import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.gis.map.dao.OGRFeatureDao;
import com.gallatinsystems.gis.map.domain.Geometry;
import com.gallatinsystems.gis.map.domain.OGRFeature;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleClusterDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocaleCluster;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import org.apache.commons.lang.StringUtils;
import org.waterforpeople.mapping.app.web.rest.security.AppRole;
import org.waterforpeople.mapping.app.web.test.DeleteObjectUtil;
import org.waterforpeople.mapping.dao.AccessPointDao;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.AccessPoint;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class TestHarnessServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(TestHarnessServlet.class.getName());
    private static final long serialVersionUID = -5673118002247715049L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        block87: {
            String action = req.getParameter("action");
            if ("setupTestUser".equals(action)) {
                this.setupTestUser();
            } else if ("deleteGeoData".equals(action)) {
                try {
                    OGRFeatureDao ogrFeatureDao = new OGRFeatureDao();
                    for (OGRFeature item : ogrFeatureDao.list("all")) {
                        resp.getWriter().println("deleting: " + item.getCountryCode());
                        ogrFeatureDao.delete(item);
                    }
                    resp.getWriter().println("Finished");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("loadOGRFeature".equals(action)) {
                OGRFeature ogrFeature = new OGRFeature();
                ogrFeature.setName("clan-21061011");
                ogrFeature.setProjectCoordinateSystemIdentifier("World_Mercator");
                ogrFeature.setGeoCoordinateSystemIdentifier("GCS_WGS_1984");
                ogrFeature.setDatumIdentifier("WGS_1984");
                ogrFeature.setSpheroid(6378137.0);
                ogrFeature.setReciprocalOfFlattening(298.257223563);
                ogrFeature.setCountryCode("LR");
                ogrFeature.addBoundingBox(223700.015625, 481399.46875, 680781.375, 945462.4375);
                Geometry geo = new Geometry();
                geo.setType(Geometry.GeometryType.POLYGON);
                String coords = "497974.5625 557051.875,498219.03125 557141.75,498655.34375 557169.4375,499001.65625 557100.1875,499250.96875 556933.9375,499167.875 556615.375,499230.1875 556407.625,499392.78125 556362.75,499385.90625 556279.875,499598.5 556067.3125,499680.25 555952.8125,499218.5625 554988.875,498775.65625 554860.1875,498674.5 554832.5625,498282.0 554734.4375,498020.34375 554554.5625,497709.59375 554374.6875,497614.84375 554374.6875,497519.46875 554369.1875,497297.3125 554359.9375,496852.96875 554355.3125,496621.125 554351.375,496695.75 554454.625,496771.59375 554604.625,496836.3125 554734.0625,496868.65625 554831.125,496847.09375 554863.4375,496760.8125 554863.4375,496663.75 554928.125,496620.625 554992.875,496555.90625 555025.1875,496448.0625 554992.875,496372.5625 555025.1875,496351.0 555133.0625,496415.71875 555197.75,496480.40625 555294.8125,496480.40625 555381.0625,496430.875 555430.75,496446.0625 555547.375,496490.53125 555849.625,496526.09375 556240.75,496721.65625 556596.375,496924.90625 556774.1875,497006.125 556845.25,497281.71875 556978.625,497610.625 556969.6875,497859.53125 556969.6875,497974.5625 557051.875";
                for (String item : coords.split(",")) {
                    String[] coord = item.split(" ");
                    geo.addCoordinate(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]));
                }
                ogrFeature.setGeometry(geo);
                ogrFeature.addGeoMeasure("CLNAME", "STRING", "Loisiana Township");
                ogrFeature.addGeoMeasure("COUNT", "FLOAT", "1");
                BaseDAO<OGRFeature> ogrDao = new BaseDAO<OGRFeature>(OGRFeature.class);
                ogrDao.save(ogrFeature);
                try {
                    resp.getWriter().println("OGRFeature: " + ogrFeature.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("generateGeocells".equals(action)) {
                AccessPointDao apDao = new AccessPointDao();
                List apList = apDao.list(null);
                if (apList != null) {
                    for (AccessPoint ap : apList) {
                        if (ap.getGeocells() != null && ap.getGeocells().size() != 0 || ap.getLatitude() == null || ap.getLongitude() == null) continue;
                        ap.setGeocells(GeocellManager.generateGeoCell((Point)new Point(ap.getLatitude().doubleValue(), ap.getLongitude().doubleValue())));
                        apDao.save(ap);
                    }
                }
            } else if ("importsinglesurvey".equals(action)) {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "importRemoteSurvey").param("source", req.getParameter("source")).param("surveyId", req.getParameter("surveyId")).param("apiKey", req.getParameter("apiKey"));
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
            } else if ("changeLocaleType".equals(action)) {
                String surveyId = req.getParameter("surveyId");
                if (surveyId == null) {
                    try {
                        resp.getWriter().println("surveyId parameter missing");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "changeLocaleType");
                if (req.getParameter("bypassBackend") == null || !req.getParameter("bypassBackend").equals("true")) {
                    options = options.header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                }
                options.param("surveyId", surveyId);
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
            } else if ("addTranslationFields".equals(action)) {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "addTranslationFields");
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
            } else if ("rebuildQuestionSummary".equals(action)) {
                String surveyId;
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "rebuildQuestionSummary");
                if (req.getParameter("bypassBackend") == null || !req.getParameter("bypassBackend").equals("true")) {
                    options = options.header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                }
                if ((surveyId = req.getParameter("surveyId")) != null && surveyId.trim().length() > 0) {
                    options.param("surveyId", surveyId);
                }
                Queue queue2 = QueueFactory.getDefaultQueue();
                queue2.add(options);
            } else if ("deleteallqsum".equals(action)) {
                DeleteObjectUtil dou = new DeleteObjectUtil();
                dou.deleteAllObjects("SurveyQuestionSummary");
            } else if ("deleteDuplicatedQAS".equals(action)) {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "deleteDuplicatedQAS").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
                try {
                    resp.getWriter().print("Request Processed - Check the logs");
                }
                catch (Exception queue2) {}
            } else if ("recomputeLocaleClusters".equals(action)) {
                SurveyedLocaleClusterDao slcDao = new SurveyedLocaleClusterDao();
                for (SurveyedLocaleCluster slc : slcDao.list("all")) {
                    slcDao.delete(slc);
                }
                Cache cache = MemCacheUtils.initCache(3600);
                if (cache != null) {
                    cache.clear();
                }
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "recomputeLocaleClusters").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
                try {
                    resp.getWriter().print("Request Processed - Check the logs");
                }
                catch (Exception e) {}
            } else if ("recreateLocales".equals(action)) {
                Queue queue = QueueFactory.getDefaultQueue();
                SurveyDAO surveyDao = new SurveyDAO();
                List sList = surveyDao.list("all");
                for (Survey s : sList) {
                    log.log(Level.INFO, "Running Remap for survey: " + s.getKey().getId());
                    queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "rerun").param("surveyId", "" + s.getKey().getId()));
                }
            } else if ("addCreationSurveyIdToLocale".equals(action)) {
                TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "addCreationSurveyIdToLocale");
                Queue queue = QueueFactory.getDefaultQueue();
                queue.add(options);
                try {
                    resp.getWriter().print("Request Processed - Check the logs");
                }
                catch (Exception sList) {}
            } else if ("populateMonitoringFieldsLocale".equals(action)) {
                if (req.getParameter("surveyId") != null) {
                    try {
                        Long surveyId = Long.parseLong(req.getParameter("surveyId"));
                        SurveyDAO sDao = new SurveyDAO();
                        Survey s = (Survey)sDao.getByKey(surveyId);
                        if (s == null) break block87;
                        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "populateMonitoringFieldsLocale").param("surveyId", surveyId.toString());
                        Queue queue = QueueFactory.getQueue((String)"background-processing");
                        queue.add(options);
                        try {
                            resp.getWriter().print("Request Processed - Check the logs");
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.SEVERE, "surveyId provided not valid: " + req.getParameter("surveyId"));
                    }
                }
            } else if ("createNewIdentifiersLocales".equals(action)) {
                if (req.getParameter("surveyId") != null) {
                    try {
                        Long surveyId = Long.parseLong(req.getParameter("surveyId"));
                        SurveyDAO sDao = new SurveyDAO();
                        Survey s = (Survey)sDao.getByKey(surveyId);
                        if (s == null) break block87;
                        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").header("Host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor")).param("action", "createNewIdentifiersLocales").param("surveyId", surveyId.toString());
                        Queue queue = QueueFactory.getQueue((String)"background-processing");
                        queue.add(options);
                        try {
                            resp.getWriter().print("Request Processed - Check the logs");
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.SEVERE, "surveyId provided not valid: " + req.getParameter("surveyId"));
                    }
                }
            } else if ("populateQuestionOrders".equals(action)) {
                log.log(Level.INFO, "Populating question and question group orders: ");
                Queue queue = QueueFactory.getDefaultQueue();
                TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "populateQuestionOrders").param("cursor", "").header("host", BackendServiceFactory.getBackendService().getBackendAddress("dataprocessor"));
                if (req.getParameter("surveyId") != null) {
                    try {
                        Long surveyId = Long.parseLong(req.getParameter("surveyId"));
                        queue.add(to.param("surveyId", surveyId.toString()));
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.SEVERE, "surveyId provided not valid: " + req.getParameter("surveyId"));
                    }
                } else {
                    queue.add(to);
                }
            } else if ("testTextQAS".equals(action)) {
                StringBuffer sb = new StringBuffer();
                QuestionAnswerStoreDao dao = new QuestionAnswerStoreDao();
                for (int i = 0; i < 16; ++i) {
                    sb.append(UUID.randomUUID().toString());
                }
                String val1 = sb.toString();
                String val2 = "TEST";
                String testResult = "OK";
                QuestionAnswerStore qas1 = new QuestionAnswerStore();
                qas1.setArbitratyNumber(0L);
                qas1.setQuestionID("0");
                qas1.setSurveyId(0L);
                qas1.setSurveyInstanceId(0L);
                qas1.setValue(val1);
                qas1 = dao.save(qas1);
                QuestionAnswerStore qas2 = new QuestionAnswerStore();
                qas2.setArbitratyNumber(1L);
                qas2.setQuestionID("1");
                qas2.setSurveyId(1L);
                qas2.setSurveyInstanceId(1L);
                qas2.setValue("TEST");
                qas2 = dao.save(qas2);
                assert (dao.getByQuestionAndSurveyInstance(0L, 0L).getValue().equals(val1));
                assert (dao.getByQuestionAndSurveyInstance(1L, 1L).getValue().equals("TEST"));
                qas1.setValue("TEST");
                qas2.setValue(val1);
                qas1 = dao.save(qas1);
                qas2 = dao.save(qas2);
                assert (dao.getByQuestionAndSurveyInstance(0L, 0L).getValue().equals("TEST"));
                assert (dao.getByQuestionAndSurveyInstance(1L, 1L).getValue().equals(val1));
                if (!dao.isCached(0L, 0L) || !dao.isCached(1L, 1L)) {
                    testResult = "NOK";
                }
                dao.delete(qas1);
                dao.delete(qas2);
                if (dao.isCached(0L, 0L) || dao.isCached(1L, 1L)) {
                    testResult = "NOK";
                }
                try {
                    PrintWriter w = resp.getWriter();
                    w.write(testResult);
                    w.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("testCacheKey".equals(action)) {
                try {
                    PrintWriter w = resp.getWriter();
                    Survey s = new Survey();
                    SurveyDAO dao = new SurveyDAO();
                    try {
                        ((Writer)w).write(dao.getCacheKey(s));
                    }
                    catch (CacheException e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                    ((Writer)w).write("\n");
                    ((Writer)w).flush();
                    ((Writer)w).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("createCascadeData".equals(action)) {
                this.createCascadeData(resp);
            }
        }
    }

    private void setupTestUser() {
        UserDao userDao = new UserDao();
        User user = userDao.findUserByEmail("test@example.com");
        if (user == null) {
            user = new User();
            user.setEmailAddress("test@example.com");
        }
        user.setSuperAdmin(true);
        user.setPermissionList(String.valueOf(AppRole.SUPER_ADMIN.getLevel()));
        user.setAccessKey(UUID.randomUUID().toString().replaceAll("-", ""));
        user.setSecret(UUID.randomUUID().toString().replaceAll("-", ""));
        userDao.save(user);
    }

    private void createCascadeData(HttpServletResponse resp) {
        String[] levelNames = new String[]{"Zone", "State", "District", "Block", "Village"};
        String name = "Cascade-" + System.currentTimeMillis();
        String[] data = new String[]{"Zone 1", "State 1", "District 1", "Block 1", "Village 1"};
        CascadeResourceDao crd = new CascadeResourceDao();
        CascadeResource cr = new CascadeResource();
        cr.setName(name);
        cr.setNumLevels(levelNames.length);
        cr.setLevelNames(Arrays.asList(levelNames));
        cr = crd.save(cr);
        SurveyGroup sg = new SurveyGroup();
        sg.setName(name);
        sg = new SurveyGroupDAO().save(sg);
        Survey s = new Survey();
        s.setName(name);
        s.setCode(name);
        s.setSurveyGroupId(sg.getKey().getId());
        s = new SurveyDAO().save(s);
        QuestionGroup qg = new QuestionGroup();
        qg.setName(name);
        qg.setSurveyId(s.getKey().getId());
        qg.setOrder(1);
        qg = new QuestionGroupDao().save(qg);
        Question q = new Question();
        q.setText(name);
        q.setType(Question.Type.CASCADE);
        q.setCascadeResourceId(cr.getKey().getId());
        q.setQuestionGroupId(qg.getKey().getId());
        q.setOrder(1);
        q = new QuestionDao().save(q);
        SurveyInstance si = new SurveyInstance();
        si.setSurveyId(s.getKey().getId());
        si.setUuid(UUID.randomUUID().toString());
        si.setCollectionDate(new Date());
        si.setUserID(1L);
        si.setSubmitterName("TestHarness");
        si = new SurveyInstanceDAO().save(si);
        QuestionAnswerStore qas = new QuestionAnswerStore();
        qas.setQuestionID(String.valueOf(q.getKey().getId()));
        qas.setSurveyId(s.getKey().getId());
        qas.setSurveyInstanceId(si.getKey().getId());
        qas.setType(Question.Type.CASCADE.toString());
        qas.setValue(StringUtils.join(Arrays.asList(data), (String)"|"));
        qas.setCollectionDate(new Date());
        qas.setArbitratyNumber(0L);
        try {
            PrintWriter w = resp.getWriter();
            ((Writer)w).write("Survey ID: " + s.getKey().getId());
            ((Writer)w).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

