/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.Message;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.web.dto.RawDataImportRequest;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class RawDataRestServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger("RawDataRestServlet");
    private static final long serialVersionUID = 2409014651721639814L;
    private static final String DATA_SUMMARIZATION_QUEUE = "dataSummarization";
    private static final String DATA_SUMMARIZATION_URL = "/app_worker/datasummarization";
    private static final String SURVEYAL_URL = "/app_worker/surveyalservlet";
    private static final String OBJECT_KEY_PARAM = "objectKey";
    private static final String TYPE_PARAM = "type";
    private static final String SI_TYPE = "SurveyInstance";
    private SurveyInstanceDAO instanceDao = new SurveyInstanceDAO();
    private SurveyDAO sDao = new SurveyDAO();
    private SurveyGroupDAO sgDao = new SurveyGroupDAO();
    private QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
    private SurveyedLocaleDao slDao = new SurveyedLocaleDao();
    private QuestionDao qDao = new QuestionDao();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        RawDataImportRequest restRequest = new RawDataImportRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RawDataImportRequest importReq = (RawDataImportRequest)req;
        if ("saveSurveyInstance".equals(importReq.getAction())) {
            Survey s = null;
            if (importReq.getSurveyId() != null) {
                s = (Survey)this.sDao.getByKey(importReq.getSurveyId());
            }
            if (s == null) {
                this.updateMessageBoard(importReq.getSurveyId(), "Survey id [" + importReq.getSurveyId() + "] doesn't exist");
                return null;
            }
            SurveyGroup sg = null;
            if (s.getSurveyGroupId() != null) {
                sg = (SurveyGroup)this.sgDao.getByKey(s.getSurveyGroupId());
            }
            if (sg == null) {
                this.updateMessageBoard(importReq.getSurveyId(), "Survey group [" + s.getSurveyGroupId() + "] doesn't exist");
                return null;
            }
            boolean isNewInstance = importReq.getSurveyInstanceId() == null;
            boolean isMonitoringForm = sg.getMonitoringGroup() != false && !sg.getNewLocaleSurveyId().equals(s.getKey().getId());
            SurveyInstance instance = null;
            if (isNewInstance) {
                if (isMonitoringForm) {
                    this.updateMessageBoard(s.getKey().getId(), "Importing new data into a monitoring form is not supported at the moment");
                    return null;
                }
                instance = this.createInstance(importReq);
            } else {
                instance = (SurveyInstance)this.instanceDao.getByKey(importReq.getSurveyInstanceId());
                if (instance == null) {
                    this.updateMessageBoard(importReq.getSurveyInstanceId(), "Survey instance id [" + importReq.getSurveyInstanceId() + "] doesn't exist");
                    return null;
                }
            }
            if (!instance.getSurveyId().equals(importReq.getSurveyId())) {
                this.updateMessageBoard(importReq.getSurveyInstanceId(), "Wrong survey selected when importing instance id [" + importReq.getSurveyInstanceId() + "]");
                return null;
            }
            Map<Long, Map<Integer, QuestionAnswerStore>> existingAnswers = this.qasDao.mapByQuestionIdAndIteration(this.qasDao.listBySurveyInstance(instance.getKey().getId()));
            Map<Long, Map<Integer, String[]>> incomingResponses = importReq.getResponseMap();
            if (incomingResponses.isEmpty()) {
                log.log(Level.WARNING, "incomingResponses is empty");
            }
            ArrayList<QuestionAnswerStore> updatedAnswers = new ArrayList<QuestionAnswerStore>();
            for (Map.Entry<Long, Map<Integer, String[]>> entry : incomingResponses.entrySet()) {
                Long questionId = entry.getKey();
                Map<Integer, String[]> iterationMap = entry.getValue();
                if (iterationMap.isEmpty()) {
                    log.log(Level.WARNING, "iterationMap is empty");
                }
                for (Map.Entry<Integer, String[]> iterationEntry : iterationMap.entrySet()) {
                    Integer iteration = iterationEntry.getKey();
                    String response = iterationEntry.getValue()[0];
                    String type = iterationEntry.getValue()[1];
                    QuestionAnswerStore answer = null;
                    if (existingAnswers.containsKey(questionId) && existingAnswers.get(questionId).containsKey(iteration)) {
                        answer = existingAnswers.get(questionId).get(iteration);
                    }
                    if (answer == null) {
                        answer = new QuestionAnswerStore();
                        answer.setQuestionID(questionId.toString());
                        answer.setSurveyInstanceId(instance.getKey().getId());
                        answer.setSurveyId(s.getKey().getId());
                        answer.setCollectionDate(instance.getCollectionDate());
                        answer.setType(type);
                        answer.setIteration(iteration);
                    }
                    answer.setValue(response);
                    updatedAnswers.add(answer);
                }
            }
            log.log(Level.INFO, "Updating " + updatedAnswers.size() + " question answers");
            this.qasDao.save((List<QuestionAnswerStore>)updatedAnswers);
            ArrayList<QuestionAnswerStore> deletedAnswers = new ArrayList<QuestionAnswerStore>();
            for (Long questionId : existingAnswers.keySet()) {
                for (Integer iteration : existingAnswers.get(questionId).keySet()) {
                    if (!incomingResponses.containsKey(questionId) || incomingResponses.get(questionId).containsKey(iteration)) continue;
                    deletedAnswers.add(existingAnswers.get(questionId).get(iteration));
                }
            }
            log.log(Level.INFO, "Deleting " + deletedAnswers.size() + " question answers");
            this.qasDao.delete((List<QuestionAnswerStore>)deletedAnswers);
            if (!isMonitoringForm && !isNewInstance) {
                SurveyedLocale surveyedLocale = this.slDao.getById(instance.getSurveyedLocaleId());
                surveyedLocale.assembleDisplayName(this.qDao.listDisplayNameQuestionsBySurveyId(s.getKey().getId()), updatedAnswers);
                this.updateDataPointLocation(surveyedLocale, updatedAnswers);
                this.slDao.save(surveyedLocale);
            }
            if (isNewInstance) {
                SurveyedLocale surveyedLocale = new SurveyedLocale();
                surveyedLocale.setIdentifier(SurveyedLocale.generateBase32Uuid());
                instance.setSurveyedLocaleIdentifier(surveyedLocale.getIdentifier());
                String privacyLevel = sg.getPrivacyLevel() != null ? sg.getPrivacyLevel().toString() : SurveyGroup.PrivacyLevel.PRIVATE.toString();
                surveyedLocale.setLocaleType(privacyLevel);
                surveyedLocale.setSurveyGroupId(sg.getKey().getId());
                surveyedLocale.setCreationSurveyId(s.getKey().getId());
                surveyedLocale.assembleDisplayName(this.qDao.listDisplayNameQuestionsBySurveyId(s.getKey().getId()), updatedAnswers);
                this.updateDataPointLocation(surveyedLocale, updatedAnswers);
                SurveyedLocale surveyedLocale2 = this.slDao.save(surveyedLocale);
                instance.setSurveyedLocaleId(surveyedLocale2.getKey().getId());
                this.instanceDao.save(instance);
                Queue defaultQueue = QueueFactory.getDefaultQueue();
                TaskOptions processSurveyedLocaleOptions = TaskOptions.Builder.withUrl((String)SURVEYAL_URL).param("action", "ingestInstance").param("surveyInstanceId", Long.toString(instance.getKey().getId())).countdownMillis(120000L);
                defaultQueue.add(processSurveyedLocaleOptions);
            }
        } else if ("resetSurveyInstance".equals(importReq.getAction())) {
            SurveyInstance instance = (SurveyInstance)this.instanceDao.getByKey(importReq.getSurveyInstanceId());
            List<QuestionAnswerStore> oldAnswers = this.instanceDao.listQuestionAnswerStore(importReq.getSurveyInstanceId(), null);
            if (oldAnswers != null && oldAnswers.size() > 0) {
                this.instanceDao.delete(oldAnswers);
                if (instance != null) {
                    instance.setLastUpdateDateTime(new Date());
                    if (importReq.getSubmitter() != null && importReq.getSubmitter().trim().length() > 0 && !"null".equalsIgnoreCase(importReq.getSubmitter().trim())) {
                        instance.setSubmitterName(importReq.getSubmitter());
                    }
                    instance.setSurveyId(importReq.getSurveyId());
                    if (importReq.getSurveyDuration() != null) {
                        instance.setSurveyalTime(importReq.getSurveyDuration());
                    }
                    this.instanceDao.save(instance);
                }
            } else if (instance == null) {
                instance = new SurveyInstance();
                instance.setKey(KeyFactory.createKey((String)SurveyInstance.class.getSimpleName(), (long)importReq.getSurveyInstanceId()));
                instance.setSurveyId(importReq.getSurveyId());
                instance.setCollectionDate(importReq.getCollectionDate());
                instance.setSubmitterName(importReq.getSubmitter());
                instance.setUserID(1L);
                instance.setUuid(UUID.randomUUID().toString());
                if (importReq.getSurveyDuration() != null) {
                    instance.setSurveyalTime(importReq.getSurveyDuration());
                }
                this.instanceDao.save(instance);
            } else {
                instance.setLastUpdateDateTime(new Date());
                if (importReq.getSubmitter() != null && importReq.getSubmitter().trim().length() > 0 && !"null".equalsIgnoreCase(importReq.getSubmitter().trim())) {
                    instance.setSubmitterName(importReq.getSubmitter());
                }
                instance.setSurveyId(importReq.getSurveyId());
                if (importReq.getSurveyDuration() != null) {
                    instance.setSurveyalTime(importReq.getSurveyDuration());
                }
                this.instanceDao.save(instance);
            }
        } else if ("ingestFixedFormat".equals(importReq.getAction())) {
            if (importReq.getFixedFieldValues() != null && importReq.getFixedFieldValues().size() > 0) {
                SurveyInstance inst = this.createInstance(importReq);
                QuestionDao questionDao = new QuestionDao();
                List<Question> questionList = questionDao.listQuestionsBySurvey(importReq.getSurveyId());
                if (questionList != null && questionList.size() >= importReq.getFixedFieldValues().size()) {
                    ArrayList<QuestionAnswerStore> answers = new ArrayList<QuestionAnswerStore>();
                    for (int i = 0; i < importReq.getFixedFieldValues().size(); ++i) {
                        String val = importReq.getFixedFieldValues().get(i);
                        if (val == null || val.trim().length() <= 0) continue;
                        QuestionAnswerStore ans = new QuestionAnswerStore();
                        ans.setQuestionID(questionList.get(i).getKey().getId() + "");
                        ans.setValue(val);
                        Question.Type type = questionList.get(i).getType();
                        if (Question.Type.GEO == type) {
                            ans.setType(QuestionDto.QuestionType.GEO.toString());
                        } else if (Question.Type.PHOTO == type) {
                            ans.setType("IMAGE");
                        } else {
                            ans.setType("VALUE");
                        }
                        ans.setSurveyId(importReq.getSurveyId());
                        ans.setSurveyInstanceId(importReq.getSurveyInstanceId());
                        ans.setCollectionDate(importReq.getCollectionDate());
                        answers.add(ans);
                    }
                    if (answers.size() > 0) {
                        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
                        qasDao.save((List<QuestionAnswerStore>)answers);
                        this.sendProcessingMessages(inst);
                    }
                } else {
                    this.log("No questions found for the survey id " + importReq.getSurveyId());
                }
            }
        } else if ("updateSummaries".equalsIgnoreCase(importReq.getAction())) {
            if (importReq.getSurveyId() == null || new SurveyDAO().getById(importReq.getSurveyId()) == null) {
                return null;
            }
            log.log(Level.INFO, "Rebuilding summaries for surveyId " + importReq.getSurveyId().toString());
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "rebuildQuestionSummary").param("surveyId", importReq.getSurveyId().toString());
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        } else if ("saveMessage".equalsIgnoreCase(importReq.getAction())) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(importReq.getSurveyId());
            SurveyUtils.notifyReportService(ids, "invalidate");
            MessageDao mdao = new MessageDao();
            Message msg = new Message();
            SurveyDAO sdao = new SurveyDAO();
            Survey s = sdao.getById(importReq.getSurveyId());
            msg.setShortMessage("Spreadsheet processed");
            msg.setObjectId(importReq.getSurveyId());
            msg.setObjectTitle(s.getPath() + "/" + s.getName());
            msg.setActionAbout("spreadsheetProcessed");
            mdao.save(msg);
        }
        return null;
    }

    private void updateDataPointLocation(SurveyedLocale dataPoint, List<QuestionAnswerStore> updatedAnswers) {
        for (QuestionAnswerStore answer : updatedAnswers) {
            if (!Question.Type.GEO.toString().equals(answer.getType())) continue;
            dataPoint.setGeoLocation(answer.getValue());
        }
    }

    private void sendProcessingMessages(SurveyInstance domain) {
        QueueFactory.getQueue((String)DATA_SUMMARIZATION_QUEUE).add(TaskOptions.Builder.withUrl((String)DATA_SUMMARIZATION_URL).param(OBJECT_KEY_PARAM, domain.getKey().getId() + "").param(TYPE_PARAM, SI_TYPE));
        QueueFactory.getDefaultQueue().add(TaskOptions.Builder.withUrl((String)SURVEYAL_URL).param("action", "ingestInstance").param("surveyInstanceId", domain.getKey().getId() + ""));
    }

    private SurveyInstance createInstance(RawDataImportRequest importReq) {
        SurveyInstance inst = new SurveyInstance();
        inst.setUserID(1L);
        inst.setSurveyId(importReq.getSurveyId());
        inst.setCollectionDate(importReq.getCollectionDate() != null ? importReq.getCollectionDate() : new Date());
        inst.setDeviceIdentifier("IMPORTER");
        inst.setUuid(UUID.randomUUID().toString());
        inst.setSurveyedLocaleId(importReq.getSurveyedLocaleId());
        inst.setUuid(UUID.randomUUID().toString());
        inst.setSubmitterName(importReq.getSubmitter());
        inst.setSurveyalTime(importReq.getSurveyDuration());
        inst.setFormVersion(importReq.getFormVersion());
        inst = this.instanceDao.save(inst);
        importReq.setSurveyInstanceId(inst.getKey().getId());
        if (importReq.getCollectionDate() == null) {
            importReq.setCollectionDate(inst.getCollectionDate());
        }
        return inst;
    }

    private void updateMessageBoard(long objectId, String shortMessage) {
        MessageDao mDao = new MessageDao();
        Message message = new Message();
        message.setObjectId(objectId);
        message.setActionAbout("importData");
        message.setShortMessage(shortMessage);
        mDao.save(message);
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

