/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.google.appengine.api.memcache.MemcacheService;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheManager;

public class MemCacheUtils {
    private static Logger log = Logger.getLogger(MemCacheUtils.class.getName());

    public static Cache initCache(Integer expirySeconds) {
        Cache cache = null;
        HashMap<Integer, Constable> props = new HashMap<Integer, Constable>();
        props.put(0, expirySeconds);
        props.put((Integer)MemcacheService.SetPolicy.SET_ALWAYS, Boolean.valueOf(true));
        try {
            CacheFactory cacheFactory = CacheManager.getInstance().getCacheFactory();
            cache = cacheFactory.createCache(props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't initialize cache: " + e.getMessage(), e);
        }
        return cache;
    }

    public static void putObject(Cache cache, Object key, Object value) {
        try {
            if (cache == null) {
                log.log(Level.WARNING, "Attempting to use an not initialized cache object");
                return;
            }
            cache.put(key, value);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to store value in memcache: " + e.getMessage(), e);
        }
    }

    public static void putObjects(Cache cache, Map<Object, Object> objects) {
        try {
            if (cache == null) {
                log.log(Level.WARNING, "Attempting to use an not initialized cache object");
                return;
            }
            cache.putAll(objects);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to store values in memcache: " + e.getMessage(), e);
        }
    }

    public static boolean containsKey(Cache cache, Object key) {
        try {
            if (cache == null) {
                log.log(Level.WARNING, "Attempting to use an not initialized cache object");
                return false;
            }
            return cache.containsKey(key);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed testing containsKey: " + e.getMessage(), e);
            return false;
        }
    }

    public static Map getObjects(Cache cache, Collection keys) {
        try {
            if (cache == null) {
                log.log(Level.WARNING, "Attempting to use an uninitialized cache object");
                return Collections.emptyMap();
            }
            return cache.getAll(keys);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to retrieve values from memcache: " + e.getMessage(), e);
            return Collections.emptyMap();
        }
    }
}

