/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.events;

import com.gallatinsystems.survey.domain.SurveyGroup;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.rest.security.user.GaeUser;
import org.akvo.flow.util.FlowJsonObjectWriter;

public class EventUtils {
    private static Logger log = Logger.getLogger(EventUtils.class.getName());
    public static final String SURVEY_GROUP_TYPE_SURVEY = "SURVEY";
    public static final String SURVEY_GROUP_TYPE_FOLDER = "FOLDER";

    public static EventTypes getEventAndActionType(String kindName) {
        switch (kindName) {
            case "QuestionAnswerStore": {
                return new EventTypes(EntityType.ANSWER, "answer");
            }
            case "SurveyInstance": {
                return new EventTypes(EntityType.FORM_INSTANCE, "formInstance");
            }
            case "SurveyedLocale": {
                return new EventTypes(EntityType.DATA_POINT, "dataPoint");
            }
            case "SurveyGroup": {
                return new EventTypes(EntityType.SURVEY_GROUP, "surveyGroup");
            }
            case "Survey": {
                return new EventTypes(EntityType.FORM, "form");
            }
            case "QuestionGroup": {
                return new EventTypes(EntityType.QUESTION_GROUP, "questionGroup");
            }
            case "Question": {
                return new EventTypes(EntityType.QUESTION, "question");
            }
            case "DeviceFiles": {
                return new EventTypes(EntityType.DEVICE_FILE, "deviceFile");
            }
            case "User": {
                return new EventTypes(EntityType.USER, "user");
            }
            case "UserAuthorization": {
                return new EventTypes(EntityType.USER_AUTHORIZATION, "userAuthorization");
            }
            case "UserRole": {
                return new EventTypes(EntityType.USER_ROLE, "userRole");
            }
        }
        return null;
    }

    private static Map<String, Object> addProperty(String key, Object val, Map<String, Object> data) {
        if (val != null) {
            data.put(key, val);
        }
        return data;
    }

    private static Map<String, Object> addProperty(String key, Object val, Object defaultVal, Map<String, Object> data) {
        if (val != null) {
            data.put(key, val);
        } else {
            data.put(key, defaultVal);
        }
        return data;
    }

    public static Map<String, Object> populateEntityProperties(EntityType type, Entity e, Map<String, Object> data) {
        switch (type) {
            case ANSWER: {
                Object text;
                EventUtils.addProperty("formInstanceId", e.getProperty("surveyInstanceId"), data);
                EventUtils.addProperty("answerType", e.getProperty("type"), data);
                EventUtils.addProperty("questionId", Long.valueOf((String)e.getProperty("questionID")), data);
                Object value = e.getProperty("value");
                if (value == null && (text = e.getProperty("valueText")) != null && text instanceof Text) {
                    value = ((Text)text).getValue();
                }
                EventUtils.addProperty("value", value, data);
                EventUtils.addProperty("formId", e.getProperty("surveyId"), data);
                EventUtils.addProperty("iteration", e.getProperty("iteration"), data);
                break;
            }
            case FORM_INSTANCE: {
                EventUtils.addProperty("formId", e.getProperty("surveyId"), data);
                EventUtils.addProperty("dataPointId", e.getProperty("surveyedLocaleId"), data);
                EventUtils.addProperty("collectionDate", e.getProperty("collectionDate"), data);
                EventUtils.addProperty("surveyalTime", e.getProperty("surveyalTime"), data);
                break;
            }
            case DATA_POINT: {
                EventUtils.addProperty("identifier", e.getProperty("identifier"), data);
                EventUtils.addProperty("lat", e.getProperty("latitude"), data);
                EventUtils.addProperty("lon", e.getProperty("longitude"), data);
                EventUtils.addProperty("name", e.getProperty("displayName"), data);
                EventUtils.addProperty("surveyId", e.getProperty("surveyGroupId"), data);
                break;
            }
            case SURVEY_GROUP: {
                EventUtils.addProperty("name", e.getProperty("name"), "<name missing>", data);
                EventUtils.addProperty("parentId", e.getProperty("parentId"), data);
                if (e.getProperty("projectType").toString().equals(SurveyGroup.ProjectType.PROJECT.toString())) {
                    data.put("surveyGroupType", SURVEY_GROUP_TYPE_SURVEY);
                } else if (e.getProperty("projectType").toString().equals(SurveyGroup.ProjectType.PROJECT_FOLDER.toString())) {
                    data.put("surveyGroupType", SURVEY_GROUP_TYPE_FOLDER);
                }
                EventUtils.addProperty("description", e.getProperty("description"), data);
                break;
            }
            case FORM: {
                EventUtils.addProperty("name", e.getProperty("name"), data);
                EventUtils.addProperty("description", e.getProperty("desc"), data);
                EventUtils.addProperty("surveyId", e.getProperty("surveyGroupId"), data);
                EventUtils.addProperty("status", e.getProperty("status"), data);
                break;
            }
            case QUESTION_GROUP: {
                EventUtils.addProperty("name", e.getProperty("name"), "<name missing>", data);
                EventUtils.addProperty("order", e.getProperty("order"), data);
                EventUtils.addProperty("formId", e.getProperty("surveyId"), data);
                break;
            }
            case QUESTION: {
                EventUtils.addProperty("displayText", e.getProperty("text"), data);
                EventUtils.addProperty("identifier", e.getProperty("questionId"), data);
                EventUtils.addProperty("questionGroupId", e.getProperty("questionGroupId"), data);
                EventUtils.addProperty("formId", e.getProperty("surveyId"), data);
                EventUtils.addProperty("questionType", e.getProperty("type"), data);
                break;
            }
            case DEVICE_FILE: {
                EventUtils.addProperty("uri", e.getProperty("URI"), data);
                EventUtils.addProperty("checksum", e.getProperty("checksum"), data);
                EventUtils.addProperty("phoneNumber", e.getProperty("phoneNumber"), data);
                EventUtils.addProperty("imei", e.getProperty("imei"), data);
                break;
            }
            case USER: {
                EventUtils.addProperty("userName", e.getProperty("userName"), data);
                EventUtils.addProperty("emailAddress", e.getProperty("emailAddress"), data);
                EventUtils.addProperty("superAdmin", e.getProperty("superAdmin"), data);
                EventUtils.addProperty("permissionList", e.getProperty("permissionList"), data);
                EventUtils.addProperty("language", e.getProperty("language"), data);
                break;
            }
            case USER_AUTHORIZATION: {
                EventUtils.addProperty("securedObjectId", e.getProperty("securedObjectId"), data);
                EventUtils.addProperty("userId", e.getProperty("userId"), data);
                EventUtils.addProperty("roleId", e.getProperty("roleId"), data);
                break;
            }
            case USER_ROLE: {
                EventUtils.addProperty("permissions", e.getProperty("permissions"), data);
                EventUtils.addProperty("name", e.getProperty("name"), data);
            }
        }
        return data;
    }

    public static Map<String, Object> newEvent(String orgId, String eventType, Map<String, Object> entity, Map<String, Object> context) throws AssertionError {
        assert (orgId != null) : "orgId is required";
        assert (eventType != null) : "eventType is required";
        assert (entity != null) : "entity is required";
        assert (context != null) : "context is required";
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orgId", orgId);
        result.put("eventType", eventType);
        result.put("entity", entity);
        result.put("context", context);
        return result;
    }

    public static Map<String, Object> newSource(Object principal) {
        HashMap<String, Object> source = new HashMap<String, Object>();
        if (principal instanceof String) {
            source.put("type", (Object)EventSourceType.SYSTEM);
        } else if (principal instanceof GaeUser) {
            GaeUser usr = (GaeUser)principal;
            source.put("type", (Object)EventSourceType.USER);
            source.put("email", usr.getEmail());
            source.put("id", usr.getUserId());
        } else {
            log.log(Level.WARNING, "Unable to identify source from authentication principal: " + principal.toString());
        }
        return source;
    }

    public static Map<String, Object> newContext(Date timestamp, Map<String, Object> source) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("timestamp", timestamp);
        context.put("source", source);
        return context;
    }

    public static Map<String, Object> newEntity(EntityType type, Long id) {
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("type", (Object)type);
        entity.put("id", id);
        return entity;
    }

    public static Entity createEventLogEntity(Map<String, Object> event, Date timestamp) throws IOException {
        Entity entity = new Entity("EventQueue");
        entity.setProperty("createdDateTime", (Object)timestamp);
        entity.setProperty("lastUpdateDateTime", (Object)timestamp);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        String payload = writer.writeAsString(event);
        if (payload.length() > 500) {
            entity.setProperty("payloadText", (Object)new Text(payload));
        } else {
            entity.setProperty("payload", (Object)payload);
        }
        return entity;
    }

    public static void sendEvents(String urlString, List<Map<String, Object>> events) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        writer.writeValue(connection.getOutputStream(), events);
        System.out.println("    " + connection.getResponseCode());
        connection.disconnect();
    }

    public static class EventTypes {
        public final EntityType type;
        public final String action;

        public EventTypes(EntityType type, String action) {
            this.type = type;
            this.action = action;
        }
    }

    public static class Prop {
        public static final String SURVEY_INSTANCE_ID = "surveyInstanceId";
        public static final String TYPE = "type";
        public static final String VALUE = "value";
        public static final String VALUE_TEXT = "valueText";
        public static final String SURVEY_ID = "surveyId";
        public static final String SURVEYED_LOCALE_ID = "surveyedLocaleId";
        public static final String COLLECTION_DATE = "collectionDate";
        public static final String SURVEYAL_TIME = "surveyalTime";
        public static final String IDENTIFIER = "identifier";
        public static final String LATITUDE = "latitude";
        public static final String LONGITUDE = "longitude";
        public static final String DISPLAY_NAME = "displayName";
        public static final String NAME = "name";
        public static final String PARENT_ID = "parentId";
        public static final String DESCRIPTION = "description";
        public static final String DESC = "desc";
        public static final String SURVEY_GROUP_ID = "surveyGroupId";
        public static final String ORDER = "order";
        public static final String TEXT = "text";
        public static final String QUESTION_ID = "questionID";
        public static final String QUESTION_IDENTIFIER = "questionId";
        public static final String QUESTION_GROUP_ID = "questionGroupId";
        public static final String PROJECT_TYPE = "projectType";
        public static final String LAST_UPDATE_DATE_TIME = "lastUpdateDateTime";
        public static final String CREATED_DATE_TIME = "createdDateTime";
        public static final String ALIAS = "alias";
        public static final String EVENT_NOTIFICATION = "eventNotification";
        public static final String ENABLE_CHANGE_EVENTS = "enableChangeEvents";
        public static final String ITERATION = "iteration";
        public static final String STATUS = "status";
    }

    static class Key {
        public static final String ID = "id";
        public static final String EMAIL = "email";
        public static final String DISPLAY_TEXT = "displayText";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String TIMESTAMP = "timestamp";
        public static final String SOURCE = "source";
        public static final String TYPE = "type";
        public static final String ORDER = "order";
        public static final String LAT = "lat";
        public static final String LON = "lon";
        public static final String ORG_ID = "orgId";
        public static final String SURVEY_ID = "surveyId";
        public static final String QUESTION_TYPE = "questionType";
        public static final String ANSWER_TYPE = "answerType";
        public static final String PARENT_ID = "parentId";
        public static final String FORM_ID = "formId";
        public static final String QUESTION_GROUP_ID = "questionGroupId";
        public static final String QUESTION_ID = "questionId";
        public static final String FORM_INSTANCE_ID = "formInstanceId";
        public static final String ANSWER_ID = "answerId";
        public static final String DATA_POINT_ID = "dataPointId";
        public static final String SUBMITTER_NAME = "submitterName";
        public static final String COLLECTION_DATE = "collectionDate";
        public static final String SURVEYAL_TIME = "surveyalTime";
        public static final String PUBLIC = "public";
        public static final String VALUE = "value";
        public static final String IDENTIFIER = "identifier";
        public static final String SURVEY_GROUP_TYPE = "surveyGroupType";
        public static final String APP_ID = "orgId";
        public static final String URL = "url";
        public static final String ITERATION = "iteration";
        public static final String STATUS = "status";

        Key() {
        }
    }

    public static class Action {
        public static final String SURVEY_GROUP = "surveyGroup";
        public static final String FORM = "form";
        public static final String QUESTION_GROUP = "questionGroup";
        public static final String QUESTION = "question";
        public static final String DATA_POINT = "dataPoint";
        public static final String FORM_INSTANCE = "formInstance";
        public static final String ANSWER = "answer";
        public static final String DEVICE_FILE = "deviceFile";
        public static final String USER = "user";
        public static final String USER_AUTHORIZATION = "userAuthorization";
        public static final String USER_ROLE = "userRole";
        public static final String DELETED = "Deleted";
        public static final String CREATED = "Created";
        public static final String UPDATED = "Updated";
        public static final String UNIFIED_LOG_NOTIFIED = "unifiedLogNotified";
    }

    public static class Kind {
        public static final String SURVEY_GROUP = "SurveyGroup";
        public static final String FORM = "Survey";
        public static final String QUESTION_GROUP = "QuestionGroup";
        public static final String QUESTION = "Question";
        public static final String DATA_POINT = "SurveyedLocale";
        public static final String FORM_INSTANCE = "SurveyInstance";
        public static final String ANSWER = "QuestionAnswerStore";
        public static final String DEVICE_FILE = "DeviceFiles";
        public static final String USER = "User";
        public static final String USER_AUTHORIZATION = "UserAuthorization";
        public static final String USER_ROLE = "UserRole";
    }

    public static enum EntityType {
        SURVEY_GROUP,
        FORM,
        QUESTION_GROUP,
        QUESTION,
        DATA_POINT,
        FORM_INSTANCE,
        ANSWER,
        DEVICE_FILE,
        USER,
        USER_AUTHORIZATION,
        USER_ROLE;

    }

    public static enum EventSourceType {
        USER,
        DEVICE,
        SENSOR,
        WEBFORM,
        API,
        UNKNOWN,
        SYSTEM;

    }
}

