/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.Message;
import org.akvo.flow.rest.dto.MessageDto;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/messages"})
public class MessageRestService {
    private MessageDao messageDao = new MessageDao();

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> listMessages(@RequestParam(value="since", defaultValue="") String since) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<MessageDto> messageList = new ArrayList<MessageDto>();
        List<Message> list = this.messageDao.listBySubject(null, null, since);
        RestStatusDto statusDto = new RestStatusDto();
        if (list != null) {
            String newSince = MessageDao.getCursor(list);
            for (Message m : list) {
                MessageDto dto = new MessageDto();
                DtoMarshaller.copyToDto(m, dto);
                messageList.add(dto);
            }
            statusDto.setSince(newSince);
            statusDto.setNum(list.size());
        }
        response.put("meta", statusDto);
        response.put("messages", messageList);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, MessageDto> getMessage(@PathVariable(value="id") Long id) {
        HashMap<String, MessageDto> response = new HashMap<String, MessageDto>();
        MessageDto dto = new MessageDto();
        Message m = (Message)this.messageDao.getByKey(id);
        if (m != null) {
            DtoMarshaller.copyToDto(m, dto);
        }
        response.put("message", dto);
        return response;
    }
}

