/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/surveyed_locales"})
public class SurveyedLocaleRestService {
    private SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> listDataPoints(@RequestParam(value="surveyGroupId", defaultValue="") Long surveyGroupId, @RequestParam(value="identifier", defaultValue="") String identifier, @RequestParam(value="ids[]", defaultValue="") Long[] ids, @RequestParam(value="displayName", defaultValue="") String displayName, @RequestParam(value="displayNamePrefix", defaultValue="") String displayNamePrefix, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="since", defaultValue="") String since) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        List<SurveyedLocale> sls = new ArrayList<SurveyedLocale>();
        ArrayList<SurveyedLocaleDto> locales = new ArrayList<SurveyedLocaleDto>();
        boolean searchIdentifiers = false;
        if (search != null && !"".equals(search) && surveyGroupId != null) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, null, null, search);
            searchIdentifiers = search.matches("^[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}$");
        } else if (identifier != null && !"".equals(identifier)) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, identifier, null, null);
        } else if (displayName != null && !"".equals(displayName)) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, null, displayName, null);
        } else if (displayNamePrefix != null && !"".equals(displayNamePrefix)) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, null, null, null, displayNamePrefix);
        } else if (surveyGroupId != null) {
            sls = this.surveyedLocaleDao.listSurveyedLocales(since, surveyGroupId, null, null, null);
        } else if (ids[0] != null) {
            sls = this.surveyedLocaleDao.listByKeys(ids);
        }
        this.copyToDtoList(sls, locales);
        if (searchIdentifiers) {
            List<SurveyedLocale> sls2 = this.surveyedLocaleDao.listSurveyedLocales(null, null, search, null, null);
            this.copyToDtoList(sls2, locales);
        }
        Integer num = locales.size();
        String newSince = SurveyedLocaleDao.getCursor(sls);
        statusDto.setNum(num);
        statusDto.setSince(newSince);
        response.put("surveyed_locales", locales);
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{dataPointId}"})
    @ResponseBody
    public Map<String, Object> findDataPointById(@PathVariable(value="dataPointId") Long dataPointId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        SurveyedLocale dataPoint = (SurveyedLocale)this.surveyedLocaleDao.getByKey(dataPointId);
        SurveyedLocaleDto dto = null;
        if (dataPoint != null) {
            dto = new SurveyedLocaleDto();
            BeanUtils.copyProperties((Object)dataPoint, (Object)dto, (String[])Constants.EXCLUDED_PROPERTIES);
            dto.setKeyId(dataPoint.getKey().getId());
        }
        response.put("surveyed_locale", dto);
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteSurveyedLocaleById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        SurveyedLocale sl = (SurveyedLocale)this.surveyedLocaleDao.getByKey(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (sl != null) {
            this.surveyedLocaleDao.deleteSurveyedLocale(sl);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    private void copyToDtoList(List<SurveyedLocale> list1, List<SurveyedLocaleDto> list2) {
        for (SurveyedLocale sl : list1) {
            SurveyedLocaleDto dto = new SurveyedLocaleDto();
            DtoMarshaller.copyToDto(sl, dto);
            list2.add(dto);
        }
    }
}

