/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.gallatinsystems.common.util.HttpUtil;
import java.util.List;

public class ImageChartUtil {
    private static final String CHART_API_URL = "http://chart.apis.google.com/chart";
    private static final String PIE_CHART_TYPE = "cht=p";
    private static final String DIM_PARAM = "&chs=";
    private static final String DATA_PARAM = "&chd=t:";
    private static final String LABEL_PARAM = "&chl=";
    private static final String LEGEND_PARAM = "&chdl=";
    private static final String TITLE_PARAM = "&chtt=";
    private static final String SCALE_PARAM = "&chds=";

    public static byte[] getPieChart(List<String> labels, List<String> values, String title, int width, int height) {
        StringBuilder urlParameters = new StringBuilder();
        urlParameters.append(PIE_CHART_TYPE).append(DIM_PARAM).append(height + "x" + width).append(DATA_PARAM);
        if (title != null) {
            urlParameters.append(TITLE_PARAM).append(title);
        }
        StringBuilder dataString = new StringBuilder();
        StringBuilder labelString = new StringBuilder();
        StringBuilder legendString = new StringBuilder();
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                dataString.append(",");
                labelString.append("|");
                legendString.append("|");
            }
            Double val = null;
            try {
                val = Double.parseDouble(values.get(i));
                int valInt = val.intValue();
                if (valInt > max) {
                    max = valInt;
                }
                if (valInt < min) {
                    min = valInt;
                }
                dataString.append(values.get(i));
                labelString.append(val);
                legendString.append(labels.get(i));
            }
            catch (Exception e) {
                System.err.println("Could not parse value. Omitting from chart: " + e);
            }
            urlParameters.append(DATA_PARAM).append(dataString.toString());
            urlParameters.append(LABEL_PARAM).append(labelString.toString());
            urlParameters.append(LEGEND_PARAM).append(legendString.toString());
            if (min == max) {
                --min;
            }
            urlParameters.append(SCALE_PARAM).append(min + "," + max);
        }
        return HttpUtil.doPost(CHART_API_URL, urlParameters.toString());
    }
}

