/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XmlValidationRule {
    private static String NUMERIC_TYPE = "numeric";
    @JacksonXmlProperty(localName="validationType", isAttribute=true)
    private String validationType;
    @JacksonXmlProperty(localName="allowDecimal", isAttribute=true)
    private boolean allowDecimal;
    @JacksonXmlProperty(localName="signed", isAttribute=true)
    private boolean signed;
    @JacksonXmlProperty(localName="minVal", isAttribute=true)
    private Double minVal;
    @JacksonXmlProperty(localName="maxVal", isAttribute=true)
    private Double maxVal;
    @JacksonXmlProperty(localName="maxLength", isAttribute=true)
    private int maxLength;

    public XmlValidationRule() {
    }

    public XmlValidationRule(Question q) {
        this.validationType = NUMERIC_TYPE;
        this.signed = Boolean.TRUE.equals(q.getAllowSign());
        this.allowDecimal = Boolean.TRUE.equals(q.getAllowDecimal());
        this.maxVal = q.getMaxVal();
        this.minVal = q.getMinVal();
    }

    public String toString() {
        return "validationRule{validationType='" + this.validationType + "',allowDecimal='" + this.allowDecimal + "',signed='" + this.signed + "',maxVal='" + this.maxVal + "',minVal='" + this.minVal + "'}";
    }

    public String getValidationType() {
        return this.validationType;
    }

    public void setValidationType(String validationType) {
        this.validationType = validationType;
    }

    public boolean getAllowDecimal() {
        return this.allowDecimal;
    }

    public void setAllowDecimal(boolean allowDecimal) {
        this.allowDecimal = allowDecimal;
    }

    public boolean getSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public Double getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Double minVal) {
        this.minVal = minVal;
    }

    public Double getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Double maxVal) {
        this.maxVal = maxVal;
    }
}

