/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.export;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.ScoringRuleDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.ScoringRule;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.KeyFactory;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.export.SurveyRestResponse;
import org.akvo.flow.domain.mapper.QuestionDtoMapper;
import org.akvo.flow.domain.mapper.QuestionOptionDtoMapper;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveySummaryDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.gwt.server.survey.SurveyServiceImpl;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.dto.SurveyRestRequest;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyRestServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(SurveyRestServlet.class.getName());
    private static final String CHART_API_URL = "http://chart.apis.google.com/chart?chs=300x225&cht=p&chtt=";
    private static final String CHART_API_DATA_PARAM = "&chd=t:";
    private static final String CHART_API_LEGEND_PARAM = "&chdl=";
    private SurveyGroupDAO sgDao;
    private SurveyDAO surveyDao;
    private QuestionOptionDao optionDao;
    private TranslationDao translationDao;
    private ScoringRuleDao scoringRuleDao;
    private QuestionGroupDao qgDao;
    private QuestionDao qDao;
    private QuestionOptionDao qoDao;
    private SurveyQuestionSummaryDao summaryDao;
    private SurveyInstanceDAO instanceDao;
    private static final long serialVersionUID = 1165507917062204859L;

    public SurveyRestServlet() {
        this.setMode("JSON");
        this.sgDao = new SurveyGroupDAO();
        this.surveyDao = new SurveyDAO();
        this.instanceDao = new SurveyInstanceDAO();
        this.optionDao = new QuestionOptionDao();
        this.translationDao = new TranslationDao();
        this.scoringRuleDao = new ScoringRuleDao();
        this.qgDao = new QuestionGroupDao();
        this.qDao = new QuestionDao();
        this.qoDao = new QuestionOptionDao();
        this.summaryDao = new SurveyQuestionSummaryDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyRestRequest restRequest = new SurveyRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyRestResponse response = new SurveyRestResponse();
        SurveyRestRequest surveyReq = (SurveyRestRequest)req;
        Boolean questionSaved = null;
        if ("saveQuestion".equals(surveyReq.getAction())) {
            questionSaved = this.saveQuestion(surveyReq);
            response.setCode("200");
            response.setMessage("Record Saved status: " + questionSaved);
        } else if ("listSurveyGroups".equals(surveyReq.getAction())) {
            response = this.listSurveyGroups(surveyReq.getCursor(), response);
        } else if ("getSurveyGroup".equals(surveyReq.getAction())) {
            SurveyGroup sg;
            Survey s;
            ArrayList<SurveyGroupDto> sgList = new ArrayList<SurveyGroupDto>();
            Long surveyGroupId = null;
            if (surveyReq.getSurveyGroupId() != null) {
                surveyGroupId = surveyReq.getSurveyGroupId();
            } else if (surveyReq.getSurveyId() != null && (s = this.surveyDao.getById(surveyReq.getSurveyId())) != null) {
                surveyGroupId = s.getSurveyGroupId();
            }
            if (surveyGroupId != null && (sg = (SurveyGroup)this.sgDao.getByKey(surveyGroupId)) != null) {
                sgList.add(new SurveyGroupDto(sg));
            }
            response.setDtoList(sgList);
        } else if ("listSurveys".equals(surveyReq.getAction())) {
            response = this.listSurveys(surveyReq.getSurveyGroupId(), surveyReq.getCursor(), response);
        } else if ("getSurvey".equals(surveyReq.getAction())) {
            ArrayList<SurveyDto> sDtoList = new ArrayList<SurveyDto>();
            sDtoList.add(this.getSurvey(new Long(surveyReq.getSurveyId())));
            response.setDtoList(sDtoList);
        } else if ("listGroups".equals(surveyReq.getAction()) || "listQuestionGroups".equals(surveyReq.getAction())) {
            response.setDtoList(this.listQuestionGroups(new Long(surveyReq.getSurveyId())));
        } else if ("listQuestions".equals(surveyReq.getAction())) {
            response.setDtoList(this.listGroupQuestionsWithLevelNames(new Long(surveyReq.getQuestionGroupId())));
        } else if ("listSurveyQuestions".equals(surveyReq.getAction())) {
            response.setDtoList(this.listSurveyQuestionsWithLevelNames(new Long(surveyReq.getSurveyId())));
        } else if ("listQuestionOptions".equals(surveyReq.getAction())) {
            response.setDtoList(this.listQuestionOptions(surveyReq.getQuestionId()));
        } else if ("listSurveyQuestionOptions".equals(surveyReq.getAction())) {
            response.setDtoList(this.listSurveyQuestionOptions(surveyReq.getSurveyId()));
        } else if ("getSummary".equals(surveyReq.getAction())) {
            response.setDtoList(this.listSummaries(new Long(surveyReq.getQuestionId())));
        } else if ("getQuestionDetails".equals(surveyReq.getAction())) {
            QuestionDto dto = this.loadQuestionDetails(new Long(surveyReq.getQuestionId()));
            ArrayList<QuestionDto> dtoList = new ArrayList<QuestionDto>();
            dtoList.add(dto);
            response.setDtoList(dtoList);
        } else if ("getSurveyInstance".equals(surveyReq.getAction())) {
            SurveyInstanceDto dto = this.findSurveyInstance(surveyReq.getInstanceId());
            ArrayList<SurveyInstanceDto> dtoList = new ArrayList<SurveyInstanceDto>();
            dtoList.add(dto);
            response.setDtoList(dtoList);
        } else if ("getGraph".equals(surveyReq.getAction())) {
            response.setUrl(this.constructChartUrl(surveyReq.getQuestionId(), surveyReq.getGraphType()));
        } else if ("updateQuestionOrder".equals(surveyReq.getAction())) {
            Question q = new Question();
            q.setKey(KeyFactory.createKey((String)"Question", (long)surveyReq.getQuestionId()));
            q.setOrder(surveyReq.getQuestionOrder());
            ArrayList<Question> questionList = new ArrayList<Question>();
            questionList.add(q);
            this.qDao.updateQuestionOrder(questionList);
        }
        return response;
    }

    private String constructChartUrl(Long questionId, String graphType) {
        StringBuilder url = new StringBuilder(CHART_API_URL);
        SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
        List<SurveyQuestionSummary> summaries = summaryDao.listByQuestion(questionId.toString());
        Question q = this.qDao.getByKey(questionId);
        if (q != null && summaries != null) {
            url.append(q.getText()).append(CHART_API_LEGEND_PARAM);
            StringBuilder legend = new StringBuilder();
            StringBuilder data = new StringBuilder();
            int i = 0;
            for (SurveyQuestionSummary sum : summaries) {
                if (i > 0) {
                    legend.append("|");
                    data.append(",");
                }
                legend.append(sum.getResponse());
                data.append(sum.getCount());
            }
            url.append(legend.toString()).append(CHART_API_DATA_PARAM).append(data.toString());
        }
        return url.toString();
    }

    private SurveyRestResponse listSurveys(Long surveyGroupId, String cursorString, SurveyRestResponse response) {
        SurveyDAO sDao = new SurveyDAO();
        List<Survey> groups = sDao.listSurveysByGroup(surveyGroupId);
        ArrayList<SurveyDto> dtoList = new ArrayList<SurveyDto>();
        cursorString = SurveyDAO.getCursor(groups);
        if (groups != null) {
            for (Survey s : groups) {
                SurveyDto dto = new SurveyDto();
                DtoMarshaller.copyToDto(s, dto);
                dto.setDescription(s.getDesc());
                dtoList.add(dto);
            }
        }
        response.setDtoList(dtoList);
        response.setCursor(cursorString);
        return response;
    }

    private SurveyDto getSurvey(Long surveyId) {
        SurveyDAO surveyDao = new SurveyDAO();
        SurveyDto dto = new SurveyDto();
        Survey s = surveyDao.getById(surveyId);
        DtoMarshaller.copyToDto(s, dto);
        dto.setDescription(s.getDesc());
        return dto;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        writer.writeValue((OutputStream)this.getResponse().getOutputStream(), resp);
    }

    private List<QuestionGroupDto> listQuestionGroups(Long surveyId) {
        TreeMap<Integer, QuestionGroup> groups = this.qgDao.listQuestionGroupsBySurvey(surveyId);
        ArrayList<QuestionGroupDto> dtoList = new ArrayList<QuestionGroupDto>();
        if (groups != null) {
            for (QuestionGroup q : groups.values()) {
                QuestionGroupDto dto = new QuestionGroupDto();
                DtoMarshaller.copyToDto(q, dto);
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    private SurveyRestResponse listSurveyGroups(String cursorString, SurveyRestResponse response) {
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        List groups = sgDao.list(cursorString);
        ArrayList<SurveyGroupDto> dtoList = new ArrayList<SurveyGroupDto>();
        cursorString = SurveyGroupDAO.getCursor(groups);
        if (groups != null) {
            for (SurveyGroup sg : groups) {
                SurveyGroupDto dto = new SurveyGroupDto();
                DtoMarshaller.copyToDto(sg, dto);
                dtoList.add(dto);
            }
        }
        response.setDtoList(dtoList);
        response.setCursor(cursorString);
        return response;
    }

    private SurveyInstanceDto findSurveyInstance(Long surveyInstanceId) {
        SurveyInstance instance = (SurveyInstance)this.instanceDao.getByKey(surveyInstanceId);
        SurveyInstanceDto dto = null;
        if (instance != null) {
            dto = new SurveyInstanceDto();
            DtoMarshaller.copyToDto(instance, dto);
            SurveyedLocaleDao slDao = new SurveyedLocaleDao();
            SurveyedLocale sl = null;
            if (instance.getSurveyedLocaleId() != null) {
                sl = slDao.getById(instance.getSurveyedLocaleId());
            }
            if (sl != null) {
                dto.setSurveyedLocaleIdentifier(sl.getIdentifier() == null ? "" : sl.getIdentifier());
                dto.setSurveyedLocaleDisplayName(sl.getDisplayName() == null ? "" : sl.getDisplayName());
            } else {
                dto.setSurveyedLocaleIdentifier("");
                dto.setSurveyedLocaleDisplayName("");
            }
        }
        return dto;
    }

    private List<QuestionDto> listQuestions(Collection<Question> questions) {
        ArrayList<QuestionDto> dtoList = new ArrayList<QuestionDto>();
        if (questions != null) {
            for (Question q : questions) {
                dtoList.add(QuestionDtoMapper.transform(q));
            }
        }
        return dtoList;
    }

    private void addLevelNames(List<QuestionDto> qlList) {
        for (QuestionDto q : qlList) {
            CascadeResource cr;
            if (!q.getType().equals((Object)QuestionDto.QuestionType.CASCADE) || q.getCascadeResourceId() == null || (cr = (CascadeResource)new CascadeResourceDao().getByKey(q.getCascadeResourceId())) == null) continue;
            q.setLevelNames(cr.getLevelNames());
        }
    }

    private List<QuestionDto> listGroupQuestionsWithLevelNames(Long groupId) {
        List<QuestionDto> qlList = this.listQuestions(this.qDao.listQuestionsByQuestionGroup(groupId, false).values());
        this.addLevelNames(qlList);
        return qlList;
    }

    private List<QuestionDto> listSurveyQuestionsWithLevelNames(Long surveyId) {
        List<QuestionDto> qlList = this.listQuestions(this.qDao.listQuestionsBySurvey(surveyId));
        this.addLevelNames(qlList);
        return qlList;
    }

    private List<QuestionOptionDto> listQuestionOptions(Long questionId) {
        List<QuestionOption> options = this.qoDao.listByQuestionId(questionId);
        ArrayList<QuestionOptionDto> dtoList = new ArrayList<QuestionOptionDto>();
        if (options != null) {
            for (QuestionOption option : options) {
                dtoList.add(QuestionOptionDtoMapper.transform(option));
            }
        }
        return dtoList;
    }

    private List<QuestionOptionDto> listSurveyQuestionOptions(Long surveyId) {
        ArrayList<QuestionOptionDto> dtoList = new ArrayList<QuestionOptionDto>();
        List<Question> questions = this.qDao.listQuestionsInOrder(surveyId, Question.Type.OPTION);
        for (Question question : questions) {
            List<QuestionOption> options = this.qoDao.listByQuestionId(question.getKey().getId());
            if (options == null) continue;
            for (QuestionOption option : options) {
                dtoList.add(QuestionOptionDtoMapper.transform(option));
            }
        }
        return dtoList;
    }

    private QuestionDto loadQuestionDetails(Long questionId) {
        Question q = this.qDao.getByKey(questionId, true);
        QuestionDto result = null;
        if (q != null) {
            result = SurveyServiceImpl.marshalQuestionDto(q);
        }
        return result;
    }

    private List<SurveySummaryDto> listSummaries(Long questionId) {
        List<SurveyQuestionSummary> summaries = this.summaryDao.listByQuestion(questionId.toString());
        ArrayList<SurveySummaryDto> dtoList = new ArrayList<SurveySummaryDto>();
        if (summaries != null) {
            for (SurveyQuestionSummary s : summaries) {
                SurveySummaryDto dto = new SurveySummaryDto();
                dto.setCount(s.getCount());
                dto.setResponseText(s.getResponse());
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    private Boolean saveQuestion(SurveyRestRequest req) throws UnsupportedEncodingException {
        String scoring;
        String dependentQuestion;
        String questionText = req.getQuestionText();
        if (questionText.length() > 499) {
            questionText = questionText.substring(0, 499);
        }
        String surveyName = this.parseLangMap(req.getSurveyName()).get("en");
        String questionGroupName = this.parseLangMap(req.getQuestionGroupName()).get("en");
        SurveyGroup sg = null;
        String surveyGroupName = req.getSurveyGroupName();
        if (surveyGroupName != null) {
            sg = this.sgDao.findBySurveyGroupName(surveyGroupName);
        }
        if (sg == null) {
            sg = new SurveyGroup();
            sg.setCode(surveyGroupName);
            this.sgDao.save(sg);
        }
        Survey survey = null;
        String surveyPath = surveyGroupName;
        survey = this.surveyDao.getByParentIdAndCode(surveyName, sg.getKey().getId());
        if (survey == null) {
            survey = new Survey();
            survey.setName(surveyName);
            survey.setPath(surveyPath);
            survey.setCode(surveyName);
            survey.setSurveyGroupId(sg.getKey().getId());
            this.surveyDao.save(survey);
        }
        QuestionGroup qg = null;
        String qgPath = surveyGroupName + "/" + surveyName;
        qg = this.qgDao.getByParentIdandCode(questionGroupName, survey.getKey().getId());
        if (qg == null) {
            qg = new QuestionGroup();
            qg.setName(questionGroupName);
            qg.setCode(questionGroupName);
            qg.setPath(qgPath);
            qg.setOrder(req.getQuestionGroupOrder());
            survey.addQuestionGroup(req.getQuestionGroupOrder(), qg);
            qg.setSurveyId(survey.getKey().getId());
            this.qgDao.save(qg);
        }
        String questionPath = qgPath + "/" + questionGroupName;
        Question q = this.qDao.getByQuestionGroupId(qg.getKey().getId(), questionText);
        Integer questionOrder = req.getQuestionOrder();
        if (q == null || !questionOrder.equals(q.getOrder())) {
            q = new Question();
        } else {
            if (Question.Type.OPTION == q.getType() || Question.Type.STRENGTH == q.getType()) {
                this.optionDao.deleteOptionsForQuestion(q.getKey().getId());
            }
            this.translationDao.deleteTranslationsForParent(q.getKey().getId(), Translation.ParentType.QUESTION_TEXT);
            this.scoringRuleDao.deleteRulesForQuestion(q.getKey().getId());
        }
        q.setText(this.parseLangMap(questionText).get("en"));
        q.setPath(questionPath);
        q.setOrder(questionOrder);
        q.setReferenceId(questionOrder.toString());
        q.setQuestionGroupId(qg.getKey().getId());
        q.setSurveyId(survey.getKey().getId());
        for (Map.Entry<String, String> qTextItem : this.parseLangMap(questionText).entrySet()) {
            if (qTextItem.getKey().equals("en")) continue;
            Translation t = new Translation();
            t.setLanguageCode(qTextItem.getKey());
            t.setText(qTextItem.getValue());
            t.setParentType(Translation.ParentType.QUESTION_TEXT);
            q.addTranslation(t);
        }
        String questionType = req.getQuestionType();
        if (questionType.equals("GEO")) {
            q.setType(Question.Type.GEO);
        } else if (questionType.equals("FREE_TEXT")) {
            q.setType(Question.Type.FREE_TEXT);
        } else if (questionType.equals("OPTION") || questionType.equals("STRENGTH")) {
            q.setAllowMultipleFlag(req.getAllowMultipleFlag());
            q.setAllowOtherFlag(req.getAllowOtherFlag());
            if (questionType.equals("OPTION")) {
                q.setType(Question.Type.OPTION);
            } else {
                q.setType(Question.Type.STRENGTH);
            }
            int i = 1;
            for (QuestionOptionContainer qoc : this.parseQuestionOption(req.getOptions())) {
                QuestionOption qo = new QuestionOption();
                qo.setText(qoc.getOption());
                qo.setCode(qoc.getOption());
                qo.setOrder(i++);
                if (qoc.getAltLangs() != null) {
                    for (QuestionOptionContainer altOpt : qoc.getAltLangs()) {
                        Translation t = new Translation();
                        t.setLanguageCode(altOpt.langCode);
                        t.setText(altOpt.getOption());
                        t.setParentType(Translation.ParentType.QUESTION_TEXT);
                        qo.addTranslation(t);
                    }
                }
                q.addQuestionOption(qo);
            }
        } else if (questionType.equals("PHOTO")) {
            q.setType(Question.Type.PHOTO);
        } else if (questionType.equals("NUMBER")) {
            q.setType(Question.Type.NUMBER);
            q.setAllowDecimal(req.getAllowDecimal());
            q.setAllowSign(req.getAllowSign());
            q.setMinVal(req.getMinVal());
            q.setMaxVal(req.getMaxVal());
        } else if (questionType.equals("VIDEO")) {
            q.setType(Question.Type.VIDEO);
        }
        if (req.getMandatoryFlag() != null) {
            q.setMandatoryFlag(req.getMandatoryFlag());
        }
        if ((dependentQuestion = req.getDependQuestion()) != null && dependentQuestion.trim().length() > 1) {
            String[] parts = dependentQuestion.split("\\|");
            Integer quesitonOrderId = new Integer(parts[0]);
            String answer = parts[1];
            Question dependsOnQuestion = this.qDao.getByGroupIdAndOrder(qg.getKey().getId(), quesitonOrderId);
            if (dependsOnQuestion != null) {
                q.setDependentFlag(true);
                q.setDependentQuestionId(dependsOnQuestion.getKey().getId());
                q.setDependentQuestionAnswer(answer);
            }
        } else {
            q.setDependentFlag(false);
        }
        q = this.qDao.save(q);
        if (q.getQuestionOptionMap() != null) {
            for (QuestionOption opt : q.getQuestionOptionMap().values()) {
                opt.setQuestionId(q.getKey().getId());
                if (opt.getText() != null && opt.getText().contains(",")) {
                    opt.setText(opt.getText().replaceAll(",", "-"));
                    if (opt.getCode() != null) {
                        opt.setCode(opt.getCode().replaceAll(",", "-"));
                    }
                }
                this.optionDao.save(opt);
                if (opt.getTranslationMap() == null) continue;
                for (Translation t : opt.getTranslationMap().values()) {
                    t.setParentId(opt.getKey().getId());
                    t.setParentType(Translation.ParentType.QUESTION_OPTION);
                    this.translationDao.save(t);
                }
            }
        }
        if (q.getTranslationMap() != null) {
            for (Translation t : q.getTranslationMap().values()) {
                t.setParentId(q.getKey().getId());
                t.setParentType(Translation.ParentType.QUESTION_TEXT);
                this.translationDao.save(t);
            }
        }
        if ((scoring = req.getScoring()) != null && scoring.trim().length() > 0 && !"null".equalsIgnoreCase(scoring)) {
            List<ScoringRule> rules = this.parseScoring(scoring, q.getKey().getId());
            this.scoringRuleDao.save(rules);
            q.setScoringRules(rules);
        }
        qg.addQuestion(questionOrder, q);
        this.qgDao.save(qg);
        this.surveyDao.save(survey);
        this.sgDao.save(sg);
        log.info("Just saved " + surveyGroupName + ":" + surveyName + ":" + questionGroupName + ":" + questionOrder);
        return true;
    }

    private ArrayList<QuestionOptionContainer> parseQuestionOption(String questionOption) {
        ArrayList<QuestionOptionContainer> qoList;
        block5: {
            String[] parts;
            block4: {
                qoList = new ArrayList<QuestionOptionContainer>();
                parts = questionOption.split("#");
                if (parts == null || parts.length != 1) break block4;
                if (!parts[0].contains("|")) {
                    String[] options = parts[0].split(";");
                    for (int i = 0; i < options.length; ++i) {
                        QuestionOptionContainer opt = this.parseEnglishOnlyOption(options[i].trim());
                        if (opt == null) continue;
                        qoList.add(opt);
                    }
                } else {
                    qoList.add(this.composeContainer(parts[0]));
                }
                break block5;
            }
            if (parts == null) break block5;
            for (String option : parts) {
                qoList.add(this.composeContainer(option));
            }
        }
        return qoList;
    }

    private QuestionOptionContainer composeContainer(String option) {
        HashMap<String, String> langVals = this.parseLangMap(option);
        String english = (String)langVals.remove("en");
        QuestionOptionContainer container = new QuestionOptionContainer("en", english);
        for (Map.Entry entry : langVals.entrySet()) {
            container.addAltLang(new QuestionOptionContainer((String)entry.getKey(), (String)entry.getValue()));
        }
        return container;
    }

    private HashMap<String, String> parseLangMap(String unparsedLangParam) {
        String[] parts;
        HashMap<String, String> langMap = new HashMap<String, String>();
        for (String item : parts = unparsedLangParam.split(";")) {
            String[] langParts = item.split("\\|");
            if (langParts.length == 1) {
                langMap.put("en", langParts[0].trim());
                continue;
            }
            langMap.put(langParts[0].trim(), langParts[1].trim());
        }
        return langMap;
    }

    private List<ScoringRule> parseScoring(String scoringParam, Long questionId) {
        String[] parts;
        ArrayList<ScoringRule> rules = new ArrayList<ScoringRule>();
        for (String item : parts = scoringParam.split(";")) {
            String[] ruleParts = item.split("\\|");
            if (ruleParts.length == 3) {
                rules.add(new ScoringRule(questionId, "NUMERIC", ruleParts[0], ruleParts[1], ruleParts[2]));
                continue;
            }
            if (ruleParts.length > 3) {
                rules.add(new ScoringRule(questionId, ruleParts[0], ruleParts[1], ruleParts[2], ruleParts[3]));
                continue;
            }
            log.log(Level.WARNING, "Scoring rule cannot be parsed: " + scoringParam);
        }
        return rules;
    }

    private QuestionOptionContainer parseEnglishOnlyOption(String option) {
        QuestionOptionContainer opt = null;
        String[] val = option.split("\\|");
        String value = null;
        if (val.length == 2) {
            value = val[1];
        } else if (val.length == 1) {
            value = val[0];
        }
        if (value != null) {
            opt = new QuestionOptionContainer("en", value);
        }
        return opt;
    }

    private class QuestionOptionContainer {
        private String langCode = null;
        private String option = null;
        private List<QuestionOptionContainer> altLangs;

        public QuestionOptionContainer(String langCode, String optionText) {
            this.setLangCode(langCode);
            this.setOption(optionText);
        }

        public List<QuestionOptionContainer> getAltLangs() {
            return this.altLangs;
        }

        public void addAltLang(QuestionOptionContainer container) {
            if (this.altLangs == null) {
                this.altLangs = new ArrayList<QuestionOptionContainer>();
            }
            this.altLangs.add(container);
        }

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }
    }
}

