/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionOption;
import java.util.ArrayList;
import java.util.List;
import org.akvo.flow.xml.XmlOption;
import org.waterforpeople.mapping.app.gwt.client.survey.OptionContainerDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XmlOptions {
    @JacksonXmlElementWrapper(localName="option", useWrapping=false)
    private List<XmlOption> option;
    @JacksonXmlProperty(localName="allowOther", isAttribute=true)
    private boolean allowOther;
    @JacksonXmlProperty(localName="allowMultiple", isAttribute=true)
    private boolean allowMultiple;
    @JacksonXmlProperty(localName="renderType", isAttribute=true)
    private String renderType;

    public XmlOptions() {
    }

    public XmlOptions(Question q) {
        this.allowOther = Boolean.TRUE.equals(q.getAllowOtherFlag());
        this.allowMultiple = Boolean.TRUE.equals(q.getAllowMultipleFlag());
        if (q.getQuestionOptionMap() != null) {
            this.option = new ArrayList<XmlOption>();
            for (QuestionOption o : q.getQuestionOptionMap().values()) {
                this.option.add(new XmlOption(o));
            }
        }
    }

    public OptionContainerDto toDto() {
        OptionContainerDto dto = new OptionContainerDto();
        dto.setAllowOtherFlag(this.allowOther);
        dto.setAllowMultipleFlag(this.allowMultiple);
        if (this.option != null) {
            ArrayList<QuestionOptionDto> oList = new ArrayList<QuestionOptionDto>();
            for (XmlOption o : this.option) {
                oList.add(o.toDto());
            }
            dto.setOptionsList(oList);
        }
        return dto;
    }

    public String toString() {
        return "options{allowOther='" + this.allowOther + "',allowMultiple='" + this.allowMultiple + "',options=" + this.option == null ? "(null)" : this.option.toString() + "}";
    }

    public List<XmlOption> getOption() {
        return this.option;
    }

    public void setOption(List<XmlOption> option) {
        this.option = option;
    }

    public boolean getAllowOther() {
        return this.allowOther;
    }

    public void setAllowOther(boolean allowOther) {
        this.allowOther = allowOther;
    }

    public boolean getAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public String getRenderType() {
        return this.renderType;
    }

    public void setRenderType(String renderType) {
        this.renderType = renderType;
    }
}

