/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/surveyed_locale_counts"})
public class SurveyedLocaleCountRestService {
    private SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
    private SurveyGroupDAO surveyGroupDAO = new SurveyGroupDAO();

    @RequestMapping(method={RequestMethod.GET}, value={"/{surveyGroupId}"})
    @ResponseBody
    public Map<String, Object> getCount(@PathVariable String surveyGroupId) {
        long id = Long.parseLong(surveyGroupId);
        SurveyGroup surveyGroup = (SurveyGroup)this.surveyGroupDAO.getByKey(id);
        if (surveyGroup == null) {
            throw new HttpMessageNotReadableException("SurveyGroup with ID " + surveyGroupId + " doesn't exist");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        Long count = this.surveyedLocaleDao.countBySurveyGroupId(id);
        HashMap<String, Object> surveyedLocaleCount = new HashMap<String, Object>();
        surveyedLocaleCount.put("keyId", surveyGroupId);
        surveyedLocaleCount.put("count", count);
        response.put("surveyed_locale_count", surveyedLocaleCount);
        return response;
    }
}

