/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.akvo.flow.dao.SurveyAssignmentDao;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.domain.persistent.SurveyAssignment;
import org.waterforpeople.mapping.app.web.dto.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class DataPointUtil {
    public List<SurveyedLocaleDto> getSurveyedLocaleDtosList(List<SurveyedLocale> slList, Long surveyId, Device device) {
        ArrayList<SurveyedLocaleDto> dtoList = new ArrayList<SurveyedLocaleDto>();
        HashMap<Long, String> questionTypeMap = new HashMap<Long, String>();
        QuestionDao questionDao = new QuestionDao();
        List<Long> surveyedLocalesIds = this.getSurveyedLocalesIds(slList);
        Map<Long, List<SurveyInstance>> surveyInstancesMap = this.getSurveyInstances(surveyedLocalesIds, surveyId, device);
        Map<Long, List<QuestionAnswerStore>> questionAnswerStore = this.getQuestionAnswerStoreMap(surveyInstancesMap);
        for (SurveyedLocale surveyedLocale : slList) {
            long surveyedLocaleId = surveyedLocale.getKey().getId();
            SurveyedLocaleDto dto = this.createSurveyedLocaleDto(surveyId, questionDao, questionTypeMap, surveyedLocale, questionAnswerStore, surveyInstancesMap.get(surveyedLocaleId));
            dtoList.add(dto);
        }
        return dtoList;
    }

    private SurveyedLocaleDto createSurveyedLocaleDto(Long surveyGroupId, QuestionDao questionDao, HashMap<Long, String> questionTypeMap, SurveyedLocale surveyedLocale, Map<Long, List<QuestionAnswerStore>> questionAnswerStoreMap, @Nullable List<SurveyInstance> surveyInstances) {
        SurveyedLocaleDto dto = new SurveyedLocaleDto();
        dto.setId(surveyedLocale.getIdentifier());
        dto.setSurveyGroupId(surveyGroupId);
        dto.setDisplayName(surveyedLocale.getDisplayName());
        dto.setLat(surveyedLocale.getLatitude());
        dto.setLon(surveyedLocale.getLongitude());
        dto.setLastUpdateDateTime(surveyedLocale.getLastUpdateDateTime());
        if (surveyInstances != null) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                Long surveyInstanceId = surveyInstance.getObjectId();
                List<QuestionAnswerStore> answerStores = questionAnswerStoreMap.get(surveyInstanceId);
                SurveyInstanceDto siDto = this.createSurveyInstanceDto(questionDao, questionTypeMap, answerStores, surveyInstance);
                dto.getSurveyInstances().add(siDto);
            }
        }
        return dto;
    }

    private Map<Long, List<QuestionAnswerStore>> getQuestionAnswerStoreMap(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
        List<Long> surveyInstancesIds = this.getSurveyInstancesIds(surveyInstanceMap);
        List questionAnswerList = questionAnswerStoreDao.fetchItemsByIdBatches(surveyInstancesIds, "surveyInstanceId");
        HashMap<Long, List<QuestionAnswerStore>> questionAnswerStoreMap = new HashMap<Long, List<QuestionAnswerStore>>();
        if (questionAnswerList != null && questionAnswerList.size() > 0) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerList) {
                Long surveyInstanceId = questionAnswerStore.getSurveyInstanceId();
                if (questionAnswerStoreMap.containsKey(surveyInstanceId)) {
                    ((List)questionAnswerStoreMap.get(surveyInstanceId)).add(questionAnswerStore);
                    continue;
                }
                ArrayList<QuestionAnswerStore> questionAnswerStores = new ArrayList<QuestionAnswerStore>();
                questionAnswerStores.add(questionAnswerStore);
                questionAnswerStoreMap.put(surveyInstanceId, questionAnswerStores);
            }
        }
        return questionAnswerStoreMap;
    }

    private List<Long> getSurveyInstancesIds(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        ArrayList<Long> surveyInstancesIds = new ArrayList<Long>();
        Collection<List<SurveyInstance>> values = surveyInstanceMap.values();
        for (List<SurveyInstance> surveyInstances : values) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                surveyInstancesIds.add(surveyInstance.getObjectId());
            }
        }
        return surveyInstancesIds;
    }

    public Map<Long, List<SurveyInstance>> getSurveyInstances(List<Long> surveyedLocalesIds, Long surveyId, Device device) {
        SurveyInstanceDAO surveyInstanceDAO = new SurveyInstanceDAO();
        boolean shouldFilter = device != null;
        HashSet<Long> allowedFormIds = new HashSet<Long>();
        if (shouldFilter) {
            SurveyAssignmentDao assignmentDao = new SurveyAssignmentDao();
            List assignments = assignmentDao.listAllContainingDevice(device.getKey().getId()).stream().filter(surveyAssignment -> surveyAssignment.getSurveyId().equals(surveyId)).collect(Collectors.toList());
            for (SurveyAssignment assignment : assignments) {
                allowedFormIds.addAll(assignment.getFormIds());
            }
        }
        List values = surveyInstanceDAO.fetchItemsByIdBatches(surveyedLocalesIds, "surveyedLocaleId");
        HashMap<Long, List<SurveyInstance>> surveyInstancesMap = new HashMap<Long, List<SurveyInstance>>();
        for (SurveyInstance surveyInstance : values) {
            Long surveyedLocaleId = surveyInstance.getSurveyedLocaleId();
            if (!surveyInstancesMap.containsKey(surveyedLocaleId)) {
                surveyInstancesMap.put(surveyedLocaleId, new ArrayList());
            }
            if (shouldFilter && !allowedFormIds.contains(surveyInstance.getSurveyId())) continue;
            ((List)surveyInstancesMap.get(surveyedLocaleId)).add(surveyInstance);
        }
        return surveyInstancesMap;
    }

    private List<Long> getSurveyedLocalesIds(List<SurveyedLocale> slList) {
        if (slList == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> surveyedLocaleIds = new ArrayList<Long>(slList.size());
        for (SurveyedLocale surveyedLocale : slList) {
            surveyedLocaleIds.add(surveyedLocale.getKey().getId());
        }
        return surveyedLocaleIds;
    }

    private SurveyInstanceDto createSurveyInstanceDto(QuestionDao qDao, HashMap<Long, String> questionTypeMap, @Nullable List<QuestionAnswerStore> questionAnswerStores, @Nullable SurveyInstance surveyInstance) {
        SurveyInstanceDto surveyInstanceDto = new SurveyInstanceDto();
        if (surveyInstance != null) {
            surveyInstanceDto.setUuid(surveyInstance.getUuid());
            surveyInstanceDto.setSubmitter(surveyInstance.getSubmitterName());
            surveyInstanceDto.setSurveyId(surveyInstance.getSurveyId());
            surveyInstanceDto.setCollectionDate(surveyInstance.getCollectionDate().getTime());
        }
        if (questionAnswerStores != null) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerStores) {
                Long questionId = questionAnswerStore.getQuestionIDLong();
                if (questionId == null) continue;
                String type = this.getQuestionType(qDao, questionTypeMap, questionAnswerStore);
                String value = this.getAnswerValue(questionAnswerStore, type);
                surveyInstanceDto.addProperty(questionId, value, type);
            }
        }
        return surveyInstanceDto;
    }

    private String getAnswerValue(QuestionAnswerStore questionAnswerStore, String type) {
        String answerValue = questionAnswerStore.getValue();
        String value = answerValue != null ? answerValue : "";
        switch (type) {
            case "OPTION": 
            case "OTHER": {
                if (!value.startsWith("[")) break;
                value = DataUtils.jsonResponsesToPipeSeparated(value);
                break;
            }
            case "IMAGE": 
            case "VIDEO": {
                value = MediaResponse.format(value, 0);
                break;
            }
        }
        return value;
    }

    private String getQuestionType(QuestionDao questionDao, HashMap<Long, String> questionTypeMap, QuestionAnswerStore questionAnswerStore) {
        String type = questionAnswerStore.getType();
        if (type == null || "".equals(type)) {
            type = "VALUE";
        } else if ("PHOTO".equals(type)) {
            type = "IMAGE";
        } else if ("OPTION".equals(type)) {
            Long questionId = questionAnswerStore.getQuestionIDLong();
            if (questionTypeMap.containsKey(questionId)) {
                type = questionTypeMap.get(questionId);
            } else {
                Question question = questionDao.getByKey(questionId);
                if (question != null) {
                    if (question.getAllowOtherFlag().booleanValue()) {
                        type = "OTHER";
                    }
                    questionTypeMap.put(questionId, type);
                }
            }
        }
        return type;
    }
}

