/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.MailUtil;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.FormSubmissionsLimit;
import org.akvo.flow.domain.Message;
import org.akvo.flow.domain.UserFormSubmissionsCounter;
import org.apache.commons.lang.StringUtils;

public class ProcessorServlet
extends HttpServlet {
    private static final long serialVersionUID = -7062679258542909086L;
    private static final Logger log = Logger.getLogger(ProcessorServlet.class.getName());
    private static final String ACTION_PARAM = "action";
    private static final String SUBMIT_ACTION = "submit";
    private static final String IMAGE_ACTION = "image";
    private static final String CASCADE_ACTION = "cascade";
    private static final String CHECKSUM_PARAM = "checksum";
    private static final String IMEI_PARAM = "imei";
    private static final String ANDROID_ID_PARAM = "androidId";
    private static final String PHONE_NUMBER_PARAM = "phoneNumber";
    private static final String FILE_NAME_PARAM = "fileName";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = StringUtils.trim((String)req.getParameter(ACTION_PARAM));
        if (action == null) {
            log.info("No action specified for processor");
            return;
        }
        log.info("  ProcessorServlet->action->" + action);
        String fileName = StringUtils.trim((String)req.getParameter(FILE_NAME_PARAM));
        String phoneNumber = StringUtils.trim((String)req.getParameter(PHONE_NUMBER_PARAM));
        String androidId = StringUtils.trim((String)req.getParameter(ANDROID_ID_PARAM));
        String imei = StringUtils.trim((String)req.getParameter(IMEI_PARAM));
        String checksum = StringUtils.trim((String)req.getParameter(CHECKSUM_PARAM));
        Survey form = null;
        Integer submissionCount = 0;
        if (SUBMIT_ACTION.equals(action)) {
            SurveyDAO surveyDAO;
            if (fileName == null) {
                log.warning("Request for processing without filename: phoneNumber=(" + phoneNumber + "); IMEI=(" + imei + ")");
                resp.setStatus(400);
                return;
            }
            Long formID = this.parseFormID(req);
            if (formID != null && (form = (surveyDAO = new SurveyDAO()).getById(formID)) == null) {
                log.warning("Form " + formID + " doesn't exist in the datastore");
                this.prepareJsonResponse(resp, 404, String.format("{\"error\": \"Form %d does not exist\", \"message\": \"It has probably been deleted\"}", formID));
                return;
            }
            FormSubmissionsLimit limiter = new FormSubmissionsLimit(this.getFormSubmissionsLimit(), this.getFormSubmissionSoftLimitPercentage());
            if (limiter.isEnabled()) {
                User user;
                UserFormSubmissionsCounter counter = new UserFormSubmissionsCounter(DatastoreServiceFactory.getDatastoreService());
                submissionCount = counter.countFor(user = (User)new UserDao().getByKey(form.getCreateUserId())) + 1;
                if (submissionCount >= limiter.getSoftLimit()) {
                    log.info("Send submission restriction mail, submissionCount: " + submissionCount);
                    this.sendFormSubmissionRestrictionEmail(user, limiter, submissionCount);
                }
                if (submissionCount >= limiter.getSoftLimit() && submissionCount <= limiter.getHardLimit()) {
                    log.info("Return hard limit error response");
                    this.prepareJsonResponse(resp, 200, String.format("{\"warning\": \"Warning, reaching the limit soon\", \"message\": \"You have reached %d%% of the form submission limit\"}", limiter.getPercentage(submissionCount)));
                }
                if (submissionCount > limiter.getHardLimit()) {
                    log.info("Return hard limit error response");
                    this.prepareJsonResponse(resp, 403, "{\"error\": \"Error, data not submitted!\", \"message\": \"You have reached the form submission limit\"}");
                    return;
                }
            }
            log.info("  ProcessorServlet->filename->" + fileName);
            Queue queue = QueueFactory.getQueue((String)"processDeviceFile");
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/task").param(ACTION_PARAM, "processFile").param(FILE_NAME_PARAM, fileName);
            if (androidId != null) {
                options.param(ANDROID_ID_PARAM, androidId);
            }
            if (phoneNumber != null) {
                options.param(PHONE_NUMBER_PARAM, phoneNumber);
            }
            if (imei != null) {
                options.param(IMEI_PARAM, imei);
            }
            if (checksum != null) {
                options.param(CHECKSUM_PARAM, checksum);
            }
            queue.add(options);
            log.info("submiting task for fileName: " + fileName);
        } else if (IMAGE_ACTION.equals(action)) {
            Device d = null;
            DeviceDAO dao = new DeviceDAO();
            d = dao.getDevice(androidId, imei, phoneNumber);
            if (d == null) {
                log.severe(String.format("No device found with imei %s or phoneNumber %s", imei, phoneNumber));
                return;
            }
            DeviceFileJobQueueDAO dfDao = new DeviceFileJobQueueDAO();
            List<DeviceFileJobQueue> missing = dfDao.listByDeviceAndFile(d.getKey().getId(), fileName);
            log.info(String.format("Deleting %s entities matching the fileName %s", missing.size(), fileName));
            dfDao.delete(missing);
        } else if (CASCADE_ACTION.equals(action)) {
            Long crId = null;
            String status = StringUtils.trim((String)req.getParameter("status"));
            String message = StringUtils.trim((String)req.getParameter("message"));
            CascadeResourceDao crDao = new CascadeResourceDao();
            try {
                crId = Long.valueOf(StringUtils.trim((String)req.getParameter("cascadeResourceId")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (crId == null || status == null) {
                log.warning(String.format("Invalid processor request - [resourceId: %s , status: %s]", crId, status));
                return;
            }
            CascadeResource cr = (CascadeResource)crDao.getByKey(crId);
            if (cr == null) {
                return;
            }
            MessageDao mDao = new MessageDao();
            Message m = new Message();
            m.setActionAbout("cascadePublish");
            if ("published".equals(status)) {
                cr.setStatus(CascadeResource.Status.PUBLISHED);
                cr.setVersion(cr.getVersion() + 1);
                m.setShortMessage("Cascade resource " + cr.getName() + " successfully published");
            } else {
                cr.setStatus(CascadeResource.Status.NOT_PUBLISHED);
                String errorMessage = "Failed to publish cascade resource " + cr.getName();
                if (StringUtils.isNotBlank((String)message)) {
                    errorMessage = errorMessage + " - Error: " + message;
                }
                m.setShortMessage(errorMessage);
            }
            crDao.save(cr);
            mDao.save(m);
        }
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Headers", "*");
        resp.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET");
    }

    private Long parseFormID(HttpServletRequest req) {
        String formID = StringUtils.trim((String)req.getParameter("formID"));
        if (StringUtils.isNotBlank((String)formID)) {
            try {
                return Long.valueOf(formID);
            }
            catch (NumberFormatException e) {
                log.warning("Form ID is not a valid number: " + formID);
            }
        }
        return null;
    }

    private void sendFormSubmissionRestrictionEmail(User user, FormSubmissionsLimit limiter, Integer count) {
        Long percentage = limiter.getPercentage(count);
        String subject = String.format("%d%% limit reached", percentage > 100L ? 100L : percentage);
        String body_1 = String.format("Dear %s,\n\nYou have reached %d%% (%d / %d forms) of the form submission limit of your FLOW Basic account. Form submissions will be blocked once the limit is reached.\n\nContact support@akvo.org to upgrade to a paid plan.\n\nRegards,\n\nThe FLOW Team", user.getUserName(), percentage, count, limiter.getHardLimit());
        String body_2 = String.format("Dear %s,\n\nYou have reached the form submission limit (%d forms). Form submissions are now blocked. You can still download your data. Please contact support@akvo.org to upgrade to a paid plan.\n\nRegards,\n\nThe FLOW Team", user.getUserName(), limiter.getHardLimit());
        TreeMap<String, String> recip = new TreeMap<String, String>();
        recip.put("support@akvo.org", "support@akvo.org");
        recip.put(user.getEmailAddress(), user.getEmailAddress());
        MailUtil.sendMail("noreply@akvo.org", null, recip, subject, count >= limiter.getHardLimit() ? body_2 : body_1);
    }

    private Integer getFormSubmissionsLimit() {
        try {
            return Integer.valueOf(PropertyUtil.getProperty("formSubmissionsLimit"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private Integer getFormSubmissionSoftLimitPercentage() {
        try {
            return Integer.valueOf(PropertyUtil.getProperty("formSubmissionsSoftLimitPercentage"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private HttpServletResponse prepareJsonResponse(HttpServletResponse response, int status, String jsonString) {
        response.setStatus(status);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            PrintWriter out = response.getWriter();
            out.print(jsonString);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }
}

