/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.domain;

import com.gallatinsystems.user.domain.User;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class UserFormSubmissionsCounter {
    private DatastoreService datastore;

    public UserFormSubmissionsCounter(DatastoreService datastore) {
        this.datastore = datastore;
    }

    public Integer countFor(User user) {
        List<Long> surveyIds = this.getSurveyIds(user);
        if (CollectionUtils.isEmpty(surveyIds)) {
            return 0;
        }
        Query q = new Query("SurveyInstance").setFilter((Query.Filter)new Query.FilterPredicate("surveyId", Query.FilterOperator.IN, surveyIds));
        PreparedQuery pq = this.datastore.prepare(q);
        return pq.countEntities(FetchOptions.Builder.withChunkSize((int)500));
    }

    private List<Long> getSurveyIds(User user) {
        ArrayList<Long> ids = new ArrayList<Long>();
        Query q = new Query("Survey").setFilter((Query.Filter)new Query.FilterPredicate("createUserId", Query.FilterOperator.EQUAL, (Object)user.getKey().getId()));
        PreparedQuery pq = this.datastore.prepare(q);
        for (Entity s : pq.asIterable(FetchOptions.Builder.withChunkSize((int)500))) {
            ids.add(s.getKey().getId());
        }
        return ids;
    }
}

