/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.notification;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.MailUtil;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.notification.dao.NotificationSubscriptionDao;
import com.gallatinsystems.notification.domain.NotificationHistory;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.notification.BaseNotificationHandler;

public abstract class AbstractReportNotificationHandler
extends BaseNotificationHandler {
    private static final Logger log = Logger.getLogger(AbstractReportNotificationHandler.class.getName());
    private static final String LINK_OPT = "LINK";
    protected static final String AWS_IDENTIFIER = "aws_identifier";
    protected static final String SURVEY_UPLOAD_URL = "surveyuploadurl";
    protected static final String REPORT_S3_PATH = "reportS3Path";
    protected static final String DATE_DISPLAY_FORMAT = "MMddyyyy";
    protected static final String ATTACH_REPORT_FLAG = "attachreport";

    @Override
    public void generateNotification(String type, Long entityId, String destinations, String destOptions, String serverBase) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        this.writeReport(entityId, serverBase, pw);
        NotificationHistory hist = this.getHistory(type, entityId);
        String newChecksum = MD5Util.generateChecksum(bos.toByteArray());
        SurveyDAO surveyDao = new SurveyDAO();
        Survey survey = surveyDao.getById(entityId);
        String emailTitle = this.getEmailSubject() + survey.getPath() + "/" + survey.getName();
        String emailBody = this.getEmailBody() + survey.getPath() + "/" + survey.getName() + " ";
        String bucketName = PropertyUtil.getProperty("s3bucket");
        String keyPrefix = PropertyUtil.getProperty(REPORT_S3_PATH);
        if (!(bos.size() <= 0 || hist.getChecksum() != null && hist.getChecksum().equals(newChecksum))) {
            hist.setChecksum(newChecksum);
            TreeMap<String, String> linkAddrList = new TreeMap<String, String>();
            ArrayList<String> attachAddrList = new ArrayList<String>();
            StringTokenizer strTok = new StringTokenizer(destinations, "||");
            StringTokenizer optTok = new StringTokenizer(destOptions, "||");
            while (strTok.hasMoreTokens()) {
                String item = strTok.nextToken();
                String opt = optTok.nextToken();
                if ("false".equalsIgnoreCase(PropertyUtil.getProperty(ATTACH_REPORT_FLAG)) || LINK_OPT.equalsIgnoreCase(opt)) {
                    linkAddrList.put(item, item);
                    continue;
                }
                attachAddrList.add(item);
            }
            if (linkAddrList.size() > 0) {
                String fileName = this.getFileName(entityId.toString());
                boolean success = false;
                try {
                    success = S3Util.put(bucketName, keyPrefix + "/" + fileName, bos.toByteArray(), "text/plain", false);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error uploading file: " + e.getMessage(), e);
                }
                if (!success) {
                    return;
                }
                this.sendMail(linkAddrList, emailTitle, emailBody + PropertyUtil.getProperty(SURVEY_UPLOAD_URL) + PropertyUtil.getProperty(REPORT_S3_PATH) + "/" + fileName);
            }
            if (attachAddrList.size() > 0) {
                String surveyCodeFormatted = this.getFileName(entityId.toString());
                MailUtil.sendMail(FROM_ADDRESS, attachAddrList, emailTitle, emailBody, bos.toByteArray(), surveyCodeFormatted, "text/plain");
            }
            NotificationSubscriptionDao.saveNotificationHistory(hist);
        }
        pw.close();
    }

    protected abstract void writeReport(Long var1, String var2, PrintWriter var3);

    protected abstract String getEmailBody();

    protected abstract String getEmailSubject();

    protected abstract String getFileName(String var1);
}

