/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.servlet;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.utils.SystemProperty;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.dao.ReportDao;
import org.akvo.flow.domain.persistent.Report;
import org.akvo.flow.rest.dto.ReportTaskRequest;
import org.akvo.flow.util.FlowJsonObjectWriter;

public class ReportServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(ReportServlet.class.getName());
    private static final long serialVersionUID = -9064136799930675167L;
    private static final String SERVLET_URL = "/app_worker/reportservlet";
    private static final Long MAX_ATTEMPTS = 5L;
    private ReportDao rDao = new ReportDao();
    private UserDao uDao = new UserDao();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        ReportTaskRequest restRequest = new ReportTaskRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        ReportTaskRequest stReq = (ReportTaskRequest)req;
        String action = stReq.getAction();
        Long id = stReq.getId();
        log.fine("action: " + action + " id: " + id + " attempt:" + stReq.getAttempt());
        Report r = (Report)this.rDao.getByKey(id);
        switch (action) {
            case "start": {
                if (r == null) break;
                if (!r.getState().equals("QUEUED")) {
                    log.warning("Cannot start report " + id + " that is " + r.getState());
                    return null;
                }
                log.fine(" ====Starting");
                int sts = 0;
                try {
                    sts = this.startReportEngine(stReq.getBaseUrl(), r);
                    log.fine(" got  " + sts);
                    if (sts == 200) {
                        return null;
                    }
                    if (sts / 100 == 4) {
                        r.setState("FINISHED_ERROR");
                        r.setMessage("Unexpected result when starting report " + id + " : " + sts);
                        this.rDao.save(r);
                        break;
                    }
                    this.requeueStart(stReq, r, sts);
                }
                catch (MalformedURLException e) {
                    log.log(Level.SEVERE, "Bad URL");
                }
                catch (IOException e) {
                    log.warning("====IOerror: " + e);
                    this.requeueStart(stReq, r, sts);
                }
                break;
            }
            case "progress": {
                if (r == null) break;
                if (!r.getState().equals("QUEUED") && !r.getState().equals("IN_PROGRESS")) {
                    log.warning("Cannot set progress on report " + id + " that is " + r.getState());
                    return null;
                }
                r.setState(stReq.getState());
                r.setMessage(stReq.getMessage());
                r.setFilename(stReq.getFilename());
                this.rDao.save(r);
                break;
            }
            default: {
                log.warning("Unknown action.");
            }
        }
        return null;
    }

    public static void queueStart(String baseUrl, Report r) {
        Queue queue = QueueFactory.getDefaultQueue();
        TaskOptions options = ReportServlet.getTaskOptions(baseUrl, 1, r);
        log.fine("Forking to task with options: " + options.toString());
        queue.add(options);
    }

    private static TaskOptions getTaskOptions(String baseUrl, int attempt, Report r) {
        return TaskOptions.Builder.withUrl((String)SERVLET_URL).param("action", "start").param("id", Long.toString(r.getKey().getId())).param("baseUrl", baseUrl).param("attempt", Long.toString(attempt));
    }

    private void requeueStart(ReportTaskRequest req, Report r, int err) {
        if ((long)req.getAttempt() >= MAX_ATTEMPTS) {
            log.warning("Abandoning START task after attempt " + req.getAttempt());
            r.setState("FINISHED_ERROR");
            r.setMessage("Could not start report generation after " + req.getAttempt() + " attempts: " + err);
            this.rDao.save(r);
        } else {
            log.warning("Requeuing START task");
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(ReportServlet.getTaskOptions(req.getBaseUrl(), req.getAttempt() + 1, r).countdownMillis(30000L));
        }
    }

    private int startReportEngine(String baseUrl, Report r) throws IOException {
        String email = ((User)this.uDao.getByKey(r.getUser())).getEmailAddress();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ReportCriteria criteria = new ReportCriteria();
        criteria.opts = new ReportOptions();
        criteria.appId = SystemProperty.applicationId.get();
        criteria.surveyId = r.getFormId().toString();
        criteria.exportType = r.getReportType();
        criteria.baseURL = baseUrl;
        criteria.opts.appId = SystemProperty.applicationId.get();
        criteria.opts.exportMode = r.getReportType();
        criteria.opts.reportId = r.getKey().getId();
        if (r.getStartDate() != null) {
            criteria.opts.from = sdf.format(r.getStartDate());
        }
        if (r.getEndDate() != null) {
            criteria.opts.to = sdf.format(r.getEndDate());
        }
        criteria.opts.lastCollection = r.getLastCollectionOnly();
        criteria.opts.questionId = r.getQuestionId();
        criteria.opts.imgPrefix = PropertyUtil.getProperty("photo_url_root");
        criteria.opts.uploadUrl = PropertyUtil.getProperty("surveyuploadurl");
        criteria.opts.uploadDir = PropertyUtil.getProperty("surveyuploaddir");
        criteria.opts.flowServices = PropertyUtil.getProperty("flowServices");
        criteria.opts.email = email;
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
        String crit = URLEncoder.encode(writer.writeAsString(criteria), "UTF-8");
        URL url = new URL(PropertyUtil.getProperty("flowServices") + "/generate?criteria=" + crit);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        log.log(Level.FINE, "Preparing to GET " + url);
        return con.getResponseCode();
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }

    class ReportCriteria
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public ReportOptions opts;
        public String exportType;
        public String appId;
        public String surveyId;
        public String baseURL;

        ReportCriteria() {
        }
    }

    class ReportOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String exportMode;
        public Long reportId;
        public Long questionId;
        public String from;
        public String to;
        public Boolean lastCollection;
        public String imgPrefix;
        public String uploadUrl;
        public String uploadDir;
        public String flowServices;
        public String appId;
        public String email;

        ReportOptions() {
        }
    }
}

