/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.servlet;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.gallatinsystems.user.domain.UserAuthorization;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.DefaultUserAuthorization;
import org.akvo.flow.domain.RootFolder;
import org.akvo.flow.rest.dto.PostUserRegistrationRestRequest;
import org.akvo.flow.rest.security.AppRole;

public class PostUserRegistrationServlet
extends AbstractRestApiServlet {
    private final String MAIN_DOMAIN = "www";
    private final String DEMO_DOMAIN = "demo";
    private UserDao userDao = new UserDao();
    private SurveyGroupDAO folderDao = new SurveyGroupDAO();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        PostUserRegistrationRestRequest restRequest = new PostUserRegistrationRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse resp = new RestResponse();
        PostUserRegistrationRestRequest request = (PostUserRegistrationRestRequest)req;
        if (!"www".equalsIgnoreCase(request.getDomain()) && !"demo".equalsIgnoreCase(request.getDomain())) {
            resp.setMessage("Not valid registration domain");
            return resp;
        }
        User newUser = this.addUser(request.getEmail(), request.getUserName());
        SurveyGroup folder = this.addFolder(newUser.getUserName(), newUser.getKey().getId());
        this.addAuthorization(newUser, folder);
        resp.setMessage("Registration completed");
        return resp;
    }

    private User addUser(String email, String userName) {
        User newUser = this.userDao.findUserByEmail(email);
        if (newUser != null) {
            return newUser;
        }
        newUser = new User();
        newUser.setEmailAddress(email);
        newUser.setUserName(userName);
        newUser.setPermissionList(Integer.toString(AppRole.ROLE_USER.getLevel()));
        newUser.setSuperAdmin(false);
        User saved = this.userDao.save(newUser);
        return saved;
    }

    private SurveyGroup addFolder(String folderName, Long creationUserId) {
        SurveyGroup folder = this.folderDao.findBySurveyGroupName(folderName);
        if (folder != null) {
            return folder;
        }
        folder = new SurveyGroup();
        folder.setProjectType(SurveyGroup.ProjectType.PROJECT_FOLDER);
        folder.setName(folderName);
        folder.setCode(folderName);
        folder.setCreateUserId(creationUserId);
        folder.setParentId(new RootFolder().getObjectId());
        folder.setPath("/" + folder.getCode());
        folder.setAncestorIds(Arrays.asList(0L));
        SurveyGroup saved = this.folderDao.save(folder);
        return saved;
    }

    private void addAuthorization(User newUser, SurveyGroup folder) {
        UserAuthorization authorization = DefaultUserAuthorization.getOrCreateDefaultAuthorization(newUser.getKey().getId(), folder.getKey().getId(), folder.getName());
        new UserAuthorizationDAO().save(authorization);
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

