/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.notification.helper;

import com.gallatinsystems.notification.dao.NotificationSubscriptionDao;
import com.gallatinsystems.notification.domain.NotificationSubscription;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationHelper {
    private static final String UNSPECIFIED = "unspecified";
    private static final String QUEUE_NAME = "notification";
    private static final String PROCESSOR_URL = "/notificationprocessor";
    private String notificationType;
    private Long subscriptionEntityId;
    private Long notificationEntityId;
    private NotificationSubscriptionDao notificationDao = new NotificationSubscriptionDao();

    public NotificationHelper(String type, Long subEntityId) {
        this(type, subEntityId, subEntityId);
    }

    public NotificationHelper(String type, Long subEntityId, Long notifEntityId) {
        this.notificationType = type;
        this.subscriptionEntityId = subEntityId;
        this.notificationEntityId = subEntityId;
        if (this.notificationEntityId == null) {
            this.notificationEntityId = this.subscriptionEntityId;
        }
    }

    public void execute() {
        List<NotificationSubscription> subs = this.notificationDao.listSubscriptions(this.subscriptionEntityId, this.notificationType, true);
        Map<String, Map<Long, List<NotificationSubscription>>> subMap = this.collateSubscriptions(subs);
        if (subMap != null) {
            Queue queue = QueueFactory.getQueue((String)QUEUE_NAME);
            for (Map.Entry<String, Map<Long, List<NotificationSubscription>>> entry : subMap.entrySet()) {
                for (Map.Entry<Long, List<NotificationSubscription>> notifEntry : entry.getValue().entrySet()) {
                    StringBuilder builder = new StringBuilder();
                    StringBuilder optBuilder = new StringBuilder();
                    if (notifEntry.getValue() == null || notifEntry.getValue().size() <= 0) continue;
                    for (int i = 0; i < notifEntry.getValue().size(); ++i) {
                        if (i > 0) {
                            builder.append("||");
                            optBuilder.append("||");
                        }
                        builder.append(notifEntry.getValue().get(i).getNotificationDestination());
                        String opt = notifEntry.getValue().get(i).getNotificationOption();
                        optBuilder.append(opt != null ? opt : UNSPECIFIED);
                    }
                    TaskOptions opts = TaskOptions.Builder.withUrl((String)PROCESSOR_URL).param("destinations", builder.toString()).param("destOptions", optBuilder.toString()).param("subEntityId", notifEntry.getKey().toString()).param("type", entry.getKey());
                    if (this.notificationEntityId != null) {
                        opts.param("notifEntityId", this.notificationEntityId.toString());
                    }
                    queue.add(opts);
                }
            }
        }
    }

    private Map<String, Map<Long, List<NotificationSubscription>>> collateSubscriptions(List<NotificationSubscription> subs) {
        HashMap<String, Map<Long, List<NotificationSubscription>>> subMap = new HashMap<String, Map<Long, List<NotificationSubscription>>>();
        if (subs != null) {
            for (NotificationSubscription sub : subs) {
                ArrayList<NotificationSubscription> tempList;
                HashMap<Long, ArrayList<NotificationSubscription>> tempMap = (HashMap<Long, ArrayList<NotificationSubscription>>)subMap.get(sub.getNotificationType());
                if (tempMap == null) {
                    tempMap = new HashMap<Long, ArrayList<NotificationSubscription>>();
                    subMap.put(sub.getNotificationType(), tempMap);
                }
                if ((tempList = (ArrayList<NotificationSubscription>)tempMap.get(sub.getEntityId())) == null) {
                    tempList = new ArrayList<NotificationSubscription>();
                    tempMap.put(sub.getEntityId(), tempList);
                }
                tempList.add(sub);
            }
        }
        return subMap;
    }
}

