/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.common.domain.UploadStatusContainer;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.WebForm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.rest.form.FormAssembler;
import org.akvo.flow.rest.form.FormMapper;
import org.akvo.flow.rest.form.FormUploadXml;
import org.akvo.flow.rest.form.QuestionGroupMapper;
import org.akvo.flow.rest.form.QuestionMapper;
import org.akvo.flow.rest.form.QuestionOptionMapper;
import org.akvo.flow.rest.form.TranslationsAppender;
import org.akvo.flow.rest.form.XmlFormAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

@Controller
@RequestMapping(value={"/form_publish"})
public class FormAssemblyRestService {
    private static final Logger log = Logger.getLogger(FormAssemblyRestService.class.getName());
    private static final String SURVEY_UPLOAD_DIR = "surveyuploaddir";
    private static final String SURVEY_UPLOAD_URL = "surveyuploadurl";
    private static final String BUCKET = "s3bucket";
    private final XmlFormAssembler xmlFormAssembler = new XmlFormAssembler();
    private final FormAssembler formAssembler = new FormAssembler(new FormMapper(new QuestionGroupMapper(new QuestionMapper(new QuestionOptionMapper()))), new TranslationsAppender());

    @PostMapping(consumes={"application/json"})
    @ResponseBody
    public SurveyDto publishForm(@RequestBody SurveyDto surveyDto) {
        SurveyGroup survey = (SurveyGroup)new SurveyGroupDAO().getByKey(surveyDto.getSurveyGroupId());
        long formId = surveyDto.getKeyId();
        Survey form = this.formAssembler.assembleForm(surveyDto);
        try {
            FormUploadXml formUploadXml = this.xmlFormAssembler.assembleXmlForm(survey, form);
            log.info("Uploading " + formId);
            UploadStatusContainer uc = this.uploadFormXML(formUploadXml.getFormIdFilename(), formUploadXml.getFormIdVersionFilename(), formUploadXml.getXmlContent());
            if (uc.getUploadedZip1().booleanValue() && uc.getUploadedZip2().booleanValue()) {
                this.formUploadSuccess(survey, form);
                log.info("Completed form assembly for " + formId);
                surveyDto.setStatus(Survey.Status.PUBLISHED.toString());
                return surveyDto;
            }
            String message = "Failed to upload assembled form, id " + formId;
            log.severe(message + "\n" + uc.getMessage());
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, message, (Throwable)new Exception(uc.getMessage()));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to convert form to XML: " + e.getMessage(), e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Failed to assemble form, id " + formId, (Throwable)e);
        }
    }

    private void formUploadSuccess(SurveyGroup survey, Survey form) {
        List<Question> questions = this.formAssembler.getQuestionList(form.getQuestionGroupMap());
        form.setStatus(Survey.Status.PUBLISHED);
        if (form.getWebForm().booleanValue()) {
            boolean webForm = WebForm.validWebForm(survey, form, questions);
            form.setWebForm(webForm);
        }
        new SurveyDAO().save(form);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(form.getObjectId());
        SurveyUtils.notifyReportService(ids, "invalidate");
    }

    public UploadStatusContainer uploadFormXML(String fileName1, String fileName2, String formXML) {
        Properties props = System.getProperties();
        String bucketName = props.getProperty(BUCKET);
        String directory = props.getProperty(SURVEY_UPLOAD_DIR);
        String uploadUrl = props.getProperty(SURVEY_UPLOAD_URL);
        UploadStatusContainer uc = new UploadStatusContainer();
        uc.setUploadedZip1(this.uploadZippedXml(formXML, bucketName, directory, fileName1));
        uc.setUploadedZip2(this.uploadZippedXml(formXML, bucketName, directory, fileName2));
        uc.setUrl(uploadUrl + directory + "/" + fileName1 + ".zip");
        return uc;
    }

    private boolean uploadZippedXml(String content, String bucketName, String directory, String fileName) {
        ByteArrayOutputStream os2 = ZipUtil.generateZip(content, fileName + ".xml");
        try {
            return S3Util.put(bucketName, directory + "/" + fileName + ".zip", os2.toByteArray(), "application/zip", true);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error uploading zip file: " + e.toString(), e);
            return false;
        }
    }
}

