/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.domain;

import com.gallatinsystems.user.dao.UserRoleDao;
import com.gallatinsystems.user.domain.Permission;
import com.gallatinsystems.user.domain.UserAuthorization;
import com.gallatinsystems.user.domain.UserRole;
import java.util.Arrays;
import java.util.HashSet;

public class DefaultUserAuthorization {
    private static final String DEFAULT_USER_ROLE_NAME = "DefaultUserRole";

    public static UserAuthorization getOrCreateDefaultAuthorization(Long newUserId, Long folderId) {
        UserRole role = DefaultUserAuthorization.getOrCreateDefaultUserRole();
        UserAuthorization auth = new UserAuthorization();
        auth.setUserId(newUserId);
        auth.setRoleId(role.getKey().getId());
        auth.setSecuredObjectId(folderId);
        return auth;
    }

    private static UserRole getOrCreateDefaultUserRole() {
        UserRole role = new UserRoleDao().findUserRoleByName(DEFAULT_USER_ROLE_NAME);
        if (role == null) {
            role = new UserRole();
            role.setName(DEFAULT_USER_ROLE_NAME);
            role.setPermissions(new HashSet<Permission>(Arrays.asList(Permission.values())));
            return new UserRoleDao().save(role);
        }
        return role;
    }
}

