/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.util.OneTimePadCypher;

public class WebFormRequest
extends RestRequest {
    private static final long serialVersionUID = 1L;
    private String webFormId;
    private String surveyId;

    @Override
    protected void populateErrors() {
        if (this.webFormId == null) {
            this.addError(new RestError("5001", "parameter wrong", "missing webformId"));
        }
        if (this.surveyId == null) {
            this.addError(new RestError("5001", "parameter wrong", "there is not a related surveyId based on current webFormId"));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.webFormId = req.getPathInfo().substring(1);
        this.surveyId = OneTimePadCypher.decrypt(PropertyUtil.getProperty("restPrivateKey"), this.webFormId);
    }

    public String getWebFormId() {
        return this.webFormId;
    }

    public void setWebFormId(String webFormId) {
        this.webFormId = webFormId;
    }

    public String getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = surveyId;
    }
}

