/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.gallatinsystems.common.util.PropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Message;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;

public class MailUtil {
    public static final String EMAIL_HOST = "emailHost";
    public static final String EMAIL_PORT = "emailPort";
    public static final String EMAIL_USER = "emailUser";
    public static final String EMAIL_PASSWORD = "emailPassword";
    private static final Logger log = Logger.getLogger(MailUtil.class.getName());

    public static Boolean sendMail(String fromAddress, String fromName, String recipient, String subject, String messageBody) {
        TreeMap<String, String> recip = new TreeMap<String, String>();
        recip.put(recipient, recipient);
        return MailUtil.sendMail(fromAddress, fromName, recip, subject, messageBody);
    }

    public static Boolean sendMail(String fromAddress, String fromName, Map<String, String> recipientList, String subject, String messageBody) {
        try {
            ArrayList<Recipient> recipients = new ArrayList<Recipient>();
            for (Map.Entry<String, String> recipientMap : recipientList.entrySet()) {
                recipients.add(new Recipient(recipientMap.getKey(), recipientMap.getValue(), Message.RecipientType.BCC));
            }
            Email email = EmailBuilder.startingBlank().from(fromName, fromAddress).withSubject(subject).withPlainText(messageBody).withRecipients(recipients).buildEmail();
            String host = PropertyUtil.getProperty(EMAIL_HOST);
            Integer port = Integer.valueOf(PropertyUtil.getProperty(EMAIL_PORT));
            String username = PropertyUtil.getProperty(EMAIL_USER);
            String password = PropertyUtil.getProperty(EMAIL_PASSWORD);
            Mailer mailer = MailerBuilder.withSMTPServer((String)host, (Integer)port, (String)username, (String)password).withTransportStrategy(TransportStrategy.SMTP_TLS).buildMailer();
            mailer.sendMail(email);
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not send mail subj:" + subject + "\n" + messageBody, e);
            return false;
        }
    }

    public static Boolean sendMail(String fromAddr, List<String> toAddressList, String subject, String body, byte[] attachmentBytes, String attachmentName, String mimeType) {
        Email email = EmailBuilder.startingBlank().from(fromAddr).toMultiple(toAddressList).withSubject(subject).appendTextHTML(body).withAttachment(attachmentName, attachmentBytes, mimeType).buildEmail();
        String host = PropertyUtil.getProperty(EMAIL_HOST);
        Integer port = Integer.valueOf(PropertyUtil.getProperty(EMAIL_PORT));
        String username = PropertyUtil.getProperty(EMAIL_USER);
        String password = PropertyUtil.getProperty(EMAIL_PASSWORD);
        Mailer mailer = MailerBuilder.withSMTPServer((String)host, (Integer)port, (String)username, (String)password).withTransportStrategy(TransportStrategy.SMTP_TLS).buildMailer();
        try {
            mailer.sendMail(email);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not send email with attachment", e);
            return false;
        }
        return true;
    }
}

