/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.device;

import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.framework.domain.DataChangeRecord;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DeviceSurveyJobQueueUpdater
implements DataSummarizer {
    private DeviceSurveyJobQueueDAO deviceSurveyJobQueueDao = new DeviceSurveyJobQueueDAO();
    private static Logger logger = Logger.getLogger(DeviceSurveyJobQueueUpdater.class.getName());

    @Override
    public String getCursor() {
        return null;
    }

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        DataChangeRecord change = new DataChangeRecord(value);
        this.deleteRecords(change.getOldVal(), change.getId());
        return true;
    }

    private void deleteRecords(String packedString, String assignmentId) {
        if (packedString != null) {
            int i;
            List<DeviceSurveyJobQueue> queueItems = this.deviceSurveyJobQueueDao.listJobByAssignment(new Long(assignmentId));
            ArrayList<DeviceSurveyJobQueue> itemsToDelete = new ArrayList<DeviceSurveyJobQueue>();
            if (packedString.contains("d")) {
                String deviceIds = packedString.substring(packedString.indexOf("d") + 1, packedString.indexOf("s"));
                String[] nums = new String[]{deviceIds};
                if (deviceIds.contains("xx")) {
                    nums = deviceIds.split("xx");
                }
                for (i = 0; i < nums.length; ++i) {
                    if (nums[i].trim().length() <= 0) continue;
                    for (DeviceSurveyJobQueue job : queueItems) {
                        if (!job.getDevicePhoneNumber().equals(nums[i])) continue;
                        itemsToDelete.add(job);
                    }
                }
            }
            if (packedString.contains("s")) {
                String surveyIds = packedString.substring(packedString.indexOf("s") + 1);
                String[] ids = new String[]{surveyIds};
                if (surveyIds.contains("xx")) {
                    ids = surveyIds.split("xx");
                }
                for (i = 0; i < ids.length; ++i) {
                    if (ids[i].trim().length() <= 0) continue;
                    for (DeviceSurveyJobQueue job : queueItems) {
                        if (!job.getSurveyID().toString().equals(ids[i])) continue;
                        itemsToDelete.add(job);
                    }
                }
            }
            if (itemsToDelete != null && itemsToDelete.size() > 0) {
                this.deviceSurveyJobQueueDao.delete(itemsToDelete);
            }
        }
    }
}

