/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.ApprovalStepDAO;
import com.gallatinsystems.survey.domain.ApprovalStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.dto.ApprovalStepDTO;
import org.waterforpeople.mapping.app.web.rest.dto.ApprovalStepPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/approval_steps"})
public class ApprovalStepRestService {
    private ApprovalStepDAO approvalStepDao = new ApprovalStepDAO();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> createApprovalStep(@RequestBody ApprovalStepPayload approvalStepPayload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ApprovalStep step = approvalStepPayload.getApproval_step().getApprovalStep();
        RestStatusDto status = new RestStatusDto();
        if (step.getApprovalGroupId() == 0L || step.getTitle() == null || step.getTitle().trim().isEmpty()) {
            return null;
        }
        response.put("approval_step", new ApprovalStepDTO(this.approvalStepDao.save(step)));
        response.put("meta", status);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{approvalStepId}"})
    @ResponseBody
    public Map<String, Object> updateApprovalStep(@RequestBody ApprovalStepPayload approvalStepPayload, @PathVariable Long approvalStepId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto status = new RestStatusDto();
        ApprovalStep updatedStep = approvalStepPayload.getApproval_step().getApprovalStep();
        if (updatedStep.getApprovalGroupId() == 0L || updatedStep.getTitle() == null || updatedStep.getTitle().trim().isEmpty()) {
            return null;
        }
        ApprovalStep storedStep = (ApprovalStep)this.approvalStepDao.getByKey(approvalStepId);
        if (storedStep != null) {
            updatedStep.setKey(storedStep.getKey());
            response.put("approval_step", new ApprovalStepDTO(this.approvalStepDao.save(updatedStep)));
        }
        response.put("meta", status);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{approvalStepId}"})
    @ResponseBody
    public void deleteApprovalStep(@PathVariable Long approvalStepId) {
        ApprovalStep approvalStep = (ApprovalStep)this.approvalStepDao.getByKey(approvalStepId);
        if (approvalStep != null) {
            this.approvalStepDao.delete(approvalStep);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{approvalStepId}"})
    @ResponseBody
    public Map<String, ApprovalStepDTO> findApprovalStep(@PathVariable Long approvalStepId) {
        HashMap<String, ApprovalStepDTO> response = new HashMap<String, ApprovalStepDTO>();
        ApprovalStep approvalStep = (ApprovalStep)this.approvalStepDao.getByKey(approvalStepId);
        if (approvalStep != null) {
            response.put("approval_step", new ApprovalStepDTO(approvalStep));
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, List<ApprovalStepDTO>> listApprovalSteps(@RequestParam(value="approvalGroupId", required=false) Long approvalGroupId) {
        HashMap<String, List<ApprovalStepDTO>> response = new HashMap<String, List<ApprovalStepDTO>>();
        ArrayList<ApprovalStep> stepsList = new ArrayList<ApprovalStep>();
        if (approvalGroupId != null) {
            stepsList.addAll(this.approvalStepDao.listByApprovalGroup(approvalGroupId));
        } else {
            stepsList.addAll(this.approvalStepDao.list("all"));
        }
        ArrayList<ApprovalStepDTO> stepsDtoList = new ArrayList<ApprovalStepDTO>();
        for (ApprovalStep step : stepsList) {
            stepsDtoList.add(new ApprovalStepDTO(step));
        }
        response.put("approval_steps", stepsDtoList);
        return response;
    }
}

