/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.gallatinsystems.framework.dataexport.applet.AbstractDataExporter;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.gwt.client.survey.OptionContainerDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class SurveySummaryExporter
extends AbstractDataExporter {
    private static final Logger log = Logger.getLogger(SurveySummaryExporter.class.getName());
    public static final String RESPONSE_KEY = "dtoList";
    private static final String SERVLET_URL = "/surveyrestapi";
    private static final NumberFormat PCT_FMT = new DecimalFormat("0.00");
    protected static final String[] ROLLUP_QUESTIONS = new String[]{"Sector/Cell", "Department", "Province", "Municipality", "Region", "District", "Traditional Authority (TA)", "Sub-Traditional Authority (Sub-TA)", "County", "Sub County", "Sector", "Cell", "Gran Panchayet", "Block", "State", "Micro-Region"};
    protected static final Map<String, String[]> ROLLUP_MAP = new HashMap<String, String[]>();
    protected List<QuestionGroupDto> orderedGroupList;
    protected List<QuestionDto> rollupOrder;

    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBase, Map<String, String> options) {
    }

    protected SummaryModel buildDataModel(String surveyId, String serverBase, String apiKey) throws Exception {
        SummaryModel model = new SummaryModel();
        Map<String, String> instanceMap = BulkDataServiceClient.fetchInstanceIds(surveyId, serverBase, apiKey, false, null, null, null);
        for (String instanceId : instanceMap.keySet()) {
            HashMap<String, String> responseMap = new HashMap<String, String>();
            Set<String> rollups = null;
            if (this.rollupOrder != null && this.rollupOrder.size() > 0) {
                rollups = this.formRollupStrings(responseMap);
            }
            for (Map.Entry entry : responseMap.entrySet()) {
                model.tallyResponse((String)entry.getKey(), rollups, (String)entry.getValue(), null);
            }
        }
        return model;
    }

    protected Set<String> formRollupStrings(Map<String, String> responseMap) {
        HashSet<String> rollups = new HashSet<String>();
        for (int j = 0; j < this.rollupOrder.size(); ++j) {
            String rollup = "";
            int count = 0;
            for (int i = 0; i < this.rollupOrder.size() - j; ++i) {
                String val = responseMap.get(this.rollupOrder.get(i).getKeyId().toString());
                if (val == null || val.trim().length() <= 0) continue;
                String jsonval = DataUtils.jsonResponsesToPipeSeparated(val);
                if (jsonval.length() > 0) {
                    val = jsonval;
                }
                if (count > 0) {
                    rollup = rollup + "|";
                }
                rollup = rollup + val;
                ++count;
            }
            rollups.add(rollup);
        }
        return rollups;
    }

    protected Map<QuestionGroupDto, List<QuestionDto>> loadAllQuestions(String surveyId, boolean performRollups, String serverBase, String apiKey) throws Exception {
        List questions;
        HashMap<QuestionGroupDto, List<QuestionDto>> questionMap = new HashMap<QuestionGroupDto, List<QuestionDto>>();
        this.orderedGroupList = this.fetchQuestionGroups(serverBase, surveyId, apiKey);
        List<QuestionDto> allQuestions = this.fetchQuestionsOfSurvey(serverBase, surveyId, apiKey);
        HashMap idMap = new HashMap();
        for (QuestionGroupDto group : this.orderedGroupList) {
            questions = new ArrayList();
            idMap.put(group.getKeyId(), questions);
        }
        for (QuestionDto q : allQuestions) {
            List myList = (List)idMap.get(q.getQuestionGroupId());
            if (myList == null) continue;
            myList.add(q);
        }
        this.rollupOrder = new ArrayList<QuestionDto>();
        for (QuestionGroupDto group : this.orderedGroupList) {
            questions = (List)idMap.get(group.getKeyId());
            Collections.sort(questions, new Comparator<QuestionDto>(){

                @Override
                public int compare(QuestionDto o1, QuestionDto o2) {
                    int v1 = o1.getOrder() != null ? o1.getOrder() : 0;
                    int v2 = o2.getOrder() != null ? o2.getOrder() : 0;
                    return v1 - v2;
                }
            });
            if (performRollups && questions != null) {
                for (QuestionDto q : questions) {
                    for (int i = 0; i < ROLLUP_QUESTIONS.length; ++i) {
                        if (!ROLLUP_QUESTIONS[i].equalsIgnoreCase(q.getText())) continue;
                        this.rollupOrder.add(q);
                    }
                }
            }
            questionMap.put(group, questions);
        }
        return questionMap;
    }

    protected void loadVariableNames(String surveyId, String serverBase, Map<QuestionGroupDto, List<QuestionDto>> questionMap, String apiKey) {
        HashMap<Long, QuestionDto> questionsById = new HashMap<Long, QuestionDto>();
        for (List<QuestionDto> qList : questionMap.values()) {
            for (QuestionDto q : qList) {
                questionsById.put(q.getKeyId(), q);
            }
        }
        try {
            List<QuestionDto> dsQuestions = this.fetchQuestionsOfSurvey(serverBase, surveyId, apiKey);
            for (QuestionDto sdDto : dsQuestions) {
                QuestionDto dto = (QuestionDto)questionsById.get(sdDto.getKeyId());
                if (dto == null || dto.getVariableName() != null) continue;
                dto.setVariableName(sdDto.getVariableName());
            }
        }
        catch (Exception e) {
            System.err.println("Could not fetch question variableNames");
            e.printStackTrace(System.err);
        }
    }

    protected void loadQuestionOptions(String surveyId, String serverBase, Map<QuestionGroupDto, List<QuestionDto>> questionMap, String apiKey) {
        try {
            HashMap<Long, QuestionDto> questionsById = new HashMap<Long, QuestionDto>();
            for (List<QuestionDto> qList : questionMap.values()) {
                for (QuestionDto q : qList) {
                    questionsById.put(q.getKeyId(), q);
                }
            }
            List<QuestionOptionDto> optList = BulkDataServiceClient.fetchSurveyQuestionOptions(surveyId, serverBase, apiKey);
            for (QuestionOptionDto o : optList) {
                QuestionDto q;
                q = (QuestionDto)questionsById.get(o.getQuestionId());
                if (q == null) continue;
                OptionContainerDto container = q.getOptionContainerDto();
                if (container == null) {
                    container = new OptionContainerDto();
                    q.setOptionContainerDto(container);
                    container.setAllowMultipleFlag(q.getAllowMultipleFlag());
                    container.setAllowOtherFlag(q.getAllowOtherFlag());
                }
                container.addQuestionOption(o);
            }
        }
        catch (Exception e) {
            System.err.println("Could not fetch question options");
            e.printStackTrace(System.err);
        }
    }

    protected List<QuestionDto> fetchQuestions(String serverBase, Long groupId, String apiKey) throws Exception {
        return this.parseQuestions(BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, "action=listQuestions&questionGroupId=" + groupId, true, apiKey));
    }

    protected List<QuestionDto> fetchQuestionsOfSurvey(String serverBase, String surveyId, String apiKey) throws Exception {
        return this.parseQuestions(BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, "action=listSurveyQuestions&surveyId=" + surveyId, true, apiKey));
    }

    protected List<QuestionGroupDto> fetchQuestionGroups(String serverBase, String surveyId, String apiKey) throws Exception {
        return this.parseQuestionGroups(BulkDataServiceClient.fetchDataFromServer(serverBase + SERVLET_URL, "action=listGroups&surveyId=" + surveyId, true, apiKey));
    }

    protected List<QuestionGroupDto> parseQuestionGroups(String response) throws Exception {
        ArrayList<QuestionGroupDto> dtoList = new ArrayList<QuestionGroupDto>();
        JSONArray arr = this.getJsonArray(response);
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject json = arr.getJSONObject(i);
                if (json == null) continue;
                QuestionGroupDto dto = new QuestionGroupDto();
                try {
                    if (json.has("code")) {
                        dto.setCode(json.getString("code"));
                    }
                    if (json.has("keyId")) {
                        dto.setKeyId(json.getLong("keyId"));
                    }
                    if (json.has("repeatable")) {
                        dto.setRepeatable(json.getBoolean("repeatable"));
                    }
                    if (json.has("order")) {
                        dto.setOrder(json.getInt("order"));
                    }
                    dtoList.add(dto);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error in json parsing: " + e.getMessage(), e);
                }
            }
        }
        return dtoList;
    }

    protected List<QuestionDto> parseQuestions(String response) throws Exception {
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        TypeReference<QuestionDto> listItemTypeReference = new TypeReference<QuestionDto>(){};
        List<QuestionDto> qList = jsonReader.readDtoListObject(response, listItemTypeReference);
        return qList;
    }

    protected JSONArray getJsonArray(String response) throws Exception {
        JSONObject json;
        log.finest("response: " + response);
        if (response != null && (json = new JSONObject(response)) != null) {
            return json.getJSONArray(RESPONSE_KEY);
        }
        return null;
    }

    static {
        ROLLUP_MAP.put("IN", new String[]{"State", "District", "Block", "Gran Panchayet"});
        ROLLUP_MAP.put("HN", new String[]{"Department", "Municipality", "Sector"});
        ROLLUP_MAP.put("GT", new String[]{"Department", "Municipality"});
        ROLLUP_MAP.put("DR", new String[]{"Province", "Municipality"});
        ROLLUP_MAP.put("NI", new String[]{"Department", "Municipality", "Micro-Region"});
        ROLLUP_MAP.put("BO", new String[]{"Department", "Municipality", "District"});
        ROLLUP_MAP.put("PE", new String[]{"Region", "Province", "District"});
        ROLLUP_MAP.put("EC", new String[]{"Province", "Municipality"});
        ROLLUP_MAP.put("MW", new String[]{"District", "Traditional Authority (TA)", "Sub-Traditional Authority (Sub-TA)"});
        ROLLUP_MAP.put("RW", new String[]{"District", "Sector", "Cell"});
        ROLLUP_MAP.put("UG", new String[]{"District", "County", "Sub County"});
    }

    protected class DescriptiveStats {
        private double max;
        private double min;
        private double mean = 0.0;
        private double sumSqMean = 0.0;
        private int sampleCount = 0;
        private List<Double> valueList = new ArrayList<Double>();
        private boolean isSorted = false;

        public DescriptiveStats() {
            this.max = Double.MIN_VALUE;
            this.min = Double.MAX_VALUE;
        }

        public int getSampleCount() {
            return this.sampleCount;
        }

        public void addSample(String stringVal) {
            double val = Double.MIN_VALUE;
            try {
                val = Double.parseDouble(stringVal);
            }
            catch (Exception e) {
                return;
            }
            ++this.sampleCount;
            if (val > this.max) {
                this.max = val;
            }
            if (val < this.min) {
                this.min = val;
            }
            double delta = val - this.mean;
            this.mean += delta / (double)this.sampleCount;
            this.sumSqMean += delta * (val - this.mean);
            this.isSorted = false;
            this.valueList.add(val);
        }

        public double getMean() {
            return this.mean;
        }

        public double getRange() {
            return this.max - this.min;
        }

        public double getVariance() {
            return this.sumSqMean / ((double)this.sampleCount - 1.0);
        }

        public double getMedian() {
            if (!this.isSorted) {
                Collections.sort(this.valueList);
                this.isSorted = true;
            }
            if (this.valueList.size() % 2 == 1) {
                return this.valueList.get((int)Math.floor(this.valueList.size() / 2));
            }
            Double lowerVal = this.valueList.get(this.valueList.size() / 2);
            Double upperVal = this.valueList.get(this.valueList.size() / 2 - 1);
            return (lowerVal + upperVal) / 2.0;
        }

        public Double getMode() {
            if (!this.isSorted) {
                Collections.sort(this.valueList);
                this.isSorted = true;
            }
            int maxOccur = 0;
            int curOccur = 0;
            Double maxOccurValue = null;
            Double lastValue = null;
            for (Double val : this.valueList) {
                if (lastValue == null || !val.equals(lastValue)) {
                    if (curOccur > maxOccur) {
                        maxOccur = curOccur;
                        maxOccurValue = lastValue;
                    }
                    lastValue = val;
                    curOccur = 1;
                    continue;
                }
                if (!val.equals(lastValue)) continue;
                ++curOccur;
            }
            if (maxOccurValue == null) {
                maxOccurValue = lastValue;
            }
            return maxOccurValue;
        }

        public double getStandardDeviation() {
            return Math.sqrt(this.getVariance());
        }

        public double getStandardError() {
            return Math.sqrt(this.getVariance() / (double)this.sampleCount);
        }

        public String getStatsString() {
            StringBuilder builder = new StringBuilder();
            if (this.sampleCount > 0) {
                builder.append(this.getMean()).append("\t").append(this.getMedian()).append("\t").append(this.getMode()).append("\t").append(this.getStandardDeviation()).append("\t").append(this.getStandardError()).append("\t").append(this.getRange());
            } else {
                builder.append("\t\t\t\t\t");
            }
            return builder.toString();
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }
    }

    protected class SummaryModel {
        private Map<String, List<String>> responseMap = new HashMap<String, List<String>>();
        private List<String> rollupList = new ArrayList<String>();
        private Map<String, Long> sectorCountMap = new HashMap<String, Long>();
        private Map<String, Long> sectorTotalMap = new HashMap<String, Long>();
        private Map<String, Long> responseCountMap = new HashMap<String, Long>();
        private Map<String, Long> responseTotalMap = new HashMap<String, Long>();
        private Map<String, DescriptiveStats> statMap = new HashMap<String, DescriptiveStats>();
        private Map<String, Map<String, DescriptiveStats>> sectorStatMap = new HashMap<String, Map<String, DescriptiveStats>>();

        public void tallyResponse(String questionId, Set<String> rollups, String response, QuestionDto qDto) {
            if (qDto != null && QuestionDto.QuestionType.NUMBER == qDto.getType() && response.endsWith(".0")) {
                response = response.substring(0, response.length() - 2);
            }
            this.addResponse(questionId, response);
            this.addRollup(rollups);
            this.incrementCount(questionId, rollups, response);
            this.updateStats(questionId, rollups, response);
        }

        private void updateStats(String questionId, Set<String> rollups, String response) {
            if (this.statMap.get(questionId) == null) {
                DescriptiveStats stats = new DescriptiveStats();
                stats.addSample(response);
                this.statMap.put(questionId, stats);
            } else {
                this.statMap.get(questionId).addSample(response);
            }
            if (rollups != null) {
                for (String sector : rollups) {
                    if (sector == null) continue;
                    if (this.sectorStatMap.get(sector) == null) {
                        HashMap<String, DescriptiveStats> secStats = new HashMap<String, DescriptiveStats>();
                        this.sectorStatMap.put(sector, secStats);
                        DescriptiveStats stats = new DescriptiveStats();
                        stats.addSample(response);
                        secStats.put(questionId, stats);
                        continue;
                    }
                    if (this.sectorStatMap.get(sector).get(questionId) == null) {
                        DescriptiveStats stats = new DescriptiveStats();
                        stats.addSample(response);
                        this.sectorStatMap.get(sector).put(questionId, stats);
                        continue;
                    }
                    this.sectorStatMap.get(sector).get(questionId).addSample(response);
                }
            }
        }

        private void incrementCount(String questionId, Set<String> rollups, String response) {
            if (rollups != null) {
                for (String sector : rollups) {
                    this.incrementValue(questionId + sector + response, this.sectorCountMap);
                    this.incrementValue(questionId + sector, this.sectorTotalMap);
                }
            }
            this.incrementValue(questionId + response, this.responseCountMap);
            this.incrementValue(questionId, this.responseTotalMap);
        }

        private void incrementValue(String key, Map<String, Long> map) {
            Long val = map.get(key);
            if (val == null) {
                val = 1L;
            } else {
                Long l = val;
                Long l2 = val = Long.valueOf(val + 1L);
            }
            map.put(key, val);
        }

        private void addRollup(Set<String> rollups) {
            if (rollups != null) {
                for (String sector : rollups) {
                    if (sector == null || sector.trim().length() <= 0 || this.rollupList.contains(sector.trim())) continue;
                    this.rollupList.add(sector.trim());
                }
            }
        }

        private void addResponse(String questionId, String response) {
            List<String> responses = this.responseMap.get(questionId);
            if (responses == null) {
                responses = new ArrayList<String>();
                this.responseMap.put(questionId, responses);
            }
            if (!responses.contains(response)) {
                responses.add(response);
            }
        }

        public String outputQuestion(String groupName, String questionText, String questionId, boolean isRolledUp) {
            String result = null;
            if (isRolledUp) {
                StringBuilder buffer = new StringBuilder();
                for (String sector : this.rollupList) {
                    buffer.append(this.outputResponses(groupName, questionText, sector, questionId, isRolledUp));
                }
                result = buffer.toString();
            } else {
                result = this.outputResponses(groupName, questionText, "", questionId, isRolledUp);
            }
            return result;
        }

        private String outputResponses(String groupName, String questionText, String sector, String questionId, boolean isRolledUp) {
            StringBuilder buffer = new StringBuilder();
            if (this.responseMap.get(questionId) != null) {
                for (String response : this.responseMap.get(questionId)) {
                    Long count = null;
                    count = isRolledUp ? this.sectorCountMap.get(questionId + sector + response) : this.responseCountMap.get(questionId + response);
                    String countString = "0";
                    String pctString = "0";
                    if (count != null) {
                        Long total = null;
                        total = isRolledUp ? this.sectorTotalMap.get(questionId + sector) : this.responseTotalMap.get(questionId);
                        pctString = PCT_FMT.format((double)count.longValue() / (double)total.longValue());
                        countString = count.toString();
                    }
                    buffer.append(groupName).append("\t").append(questionText).append("\t");
                    if (isRolledUp) {
                        buffer.append(sector).append("\t");
                    }
                    buffer.append(response).append("\t").append(countString).append("\t").append(pctString).append("\t").append(this.statMap.get(questionId).getStatsString()).append("\n");
                }
            }
            return buffer.toString();
        }

        public Map<String, Long> getResponseCountsForQuestion(Long questionId, String sector) {
            List<String> responses = this.responseMap.get(questionId.toString());
            HashMap<String, Long> countMap = new HashMap<String, Long>();
            if (responses != null) {
                for (String resp : responses) {
                    Long count = null;
                    count = sector == null ? this.responseCountMap.get(questionId + resp) : this.sectorCountMap.get(questionId + sector + resp);
                    countMap.put(resp, count != null ? count : new Long(0L));
                }
            }
            return countMap;
        }

        public DescriptiveStats getDescriptiveStatsForQuestion(Long questionId, String sector) {
            if (sector == null) {
                return this.statMap.get(questionId.toString());
            }
            if (this.sectorStatMap.get(sector) != null) {
                return this.sectorStatMap.get(sector).get(questionId.toString());
            }
            return null;
        }

        public List<String> getSectorList() {
            return this.rollupList;
        }
    }
}

