/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.akvo.flow.xml.XmlAltText;
import org.akvo.flow.xml.XmlQuestion;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XmlQuestionGroup {
    @JacksonXmlProperty(localName="repeatable", isAttribute=true)
    private Boolean repeatable;
    @JacksonXmlProperty(localName="heading", isAttribute=false)
    private String heading;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;
    @JacksonXmlElementWrapper(localName="question", useWrapping=false)
    private ArrayList<XmlQuestion> question;
    @JsonIgnore
    private int order;

    public XmlQuestionGroup() {
    }

    public XmlQuestionGroup(QuestionGroup group) {
        this.heading = group.getCode();
        if (this.heading == null) {
            this.heading = group.getName();
        }
        this.order = group.getOrder();
        this.repeatable = group.getRepeatable();
        if (group.getTranslations() != null) {
            this.altText = new ArrayList<XmlAltText>();
            for (Translation t : group.getTranslations().values()) {
                this.altText.add(new XmlAltText(t));
            }
        }
        if (group.getQuestionMap() != null) {
            this.question = new ArrayList();
            for (Question q : group.getQuestionMap().values()) {
                this.question.add(new XmlQuestion(q));
            }
        }
    }

    public QuestionGroupDto toDto() {
        HashMap<String, TranslationDto> qMap;
        QuestionGroupDto dto = new QuestionGroupDto();
        dto.setName(this.heading);
        dto.setCode(this.heading);
        dto.setOrder(this.order);
        dto.setRepeatable(this.repeatable);
        if (this.altText != null) {
            qMap = new HashMap();
            for (XmlAltText alt : this.altText) {
                qMap.put(alt.getLanguage(), alt.toDto());
            }
            dto.setTranslationMap(qMap);
        }
        if (this.question != null) {
            qMap = new TreeMap();
            for (XmlQuestion q : this.question) {
                ((TreeMap)((Object)qMap)).put((String)((Object)Integer.valueOf(q.getOrder())), (TranslationDto)((Object)q.toDto()));
            }
            dto.setQuestionList(new ArrayList<QuestionDto>(((TreeMap)((Object)qMap)).values()));
        }
        return dto;
    }

    public String toString() {
        return "questionGroup{order='" + this.order + "',heading='" + this.heading + "',repeatable='" + this.repeatable + "}";
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String h) {
        this.heading = h;
    }

    public Boolean getRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ArrayList<XmlQuestion> getQuestion() {
        return this.question;
    }

    public void setQuestion(ArrayList<XmlQuestion> qs) {
        this.question = qs;
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }
}

