/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.gis.map.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.gis.geography.dao.CountryDao;
import com.gallatinsystems.gis.geography.domain.Country;
import com.gallatinsystems.gis.map.domain.OGRFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class OGRFeatureDao
extends BaseDAO<OGRFeature> {
    public OGRFeatureDao() {
        super(OGRFeature.class);
    }

    public List<OGRFeature> listBySubLevelCountryName(String countryCode, Integer level, String subLevelValue, String cursorString, String parentSubPath) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap, " == ");
        if (level > 0) {
            this.appendNonNullParam("sub" + level, filterString, paramString, "String", subLevelValue, paramMap, " == ");
        }
        if (parentSubPath != null) {
            String[] subParts = parentSubPath.split("/");
            for (int i = 1; i < subParts.length; ++i) {
                this.appendNonNullParam("sub" + i, filterString, paramString, "String", subParts[i], paramMap, " == ");
            }
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        List resultsGTE = (List)query.executeWithMap(paramMap);
        return resultsGTE;
    }

    public List<OGRFeature> listByExtentAndType(Double x1, Double y1, OGRFeature.FeatureType featureType, String orderByCol, String orderByDirection, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("x1", filterString, paramString, "Double", x1, paramMap, " <= ");
        this.appendNonNullParam("featureType", filterString, paramString, "String", (Object)featureType, paramMap, " == ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        if (orderByCol != null && orderByDirection != null) {
            query.setOrdering(orderByCol + " " + orderByDirection);
        }
        this.prepareCursor(cursorString, query);
        List resultsGTE = (List)query.executeWithMap(paramMap);
        ArrayList<OGRFeature> results = new ArrayList<OGRFeature>();
        for (OGRFeature item : resultsGTE) {
            Double[] boundingBox = item.getBoundingBox();
            if (!(boundingBox[0] < x1) || !(boundingBox[1] > y1) || !(boundingBox[2] > x1) || !(boundingBox[3] < y1)) continue;
            results.add(item);
        }
        return results;
    }

    public List<OGRFeature> listByExtentTypeCountry(Double x1, Double y1, String countryCode, String orderByCol, String orderByDirection, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("x1", filterString, paramString, "Double", x1, paramMap, " <= ");
        this.appendNonNullParam("featureType", filterString, paramString, "String", (Object)OGRFeature.FeatureType.SUB_COUNTRY_OTHER, paramMap, " == ");
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap, " == ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        if (orderByCol != null && orderByDirection != null) {
            query.setOrdering(orderByCol + " " + orderByDirection);
        }
        this.prepareCursor(cursorString, query);
        List resultsGTE = (List)query.executeWithMap(paramMap);
        ArrayList<OGRFeature> results = new ArrayList<OGRFeature>();
        for (OGRFeature item : resultsGTE) {
            Double[] boundingBox = item.getBoundingBox();
            if (!(boundingBox[0] < x1) || !(boundingBox[1] > y1) || !(boundingBox[2] > x1) || !(boundingBox[3] < y1)) continue;
            results.add(item);
        }
        return results;
    }

    public List<OGRFeature> listBySubLevelCountry(String countryCode, Integer subLevel, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap, " == ");
        this.appendNonNullParam("featureType", filterString, paramString, "String", (Object)OGRFeature.FeatureType.SUB_COUNTRY_OTHER, paramMap, " == ");
        this.appendNonNullParam("sub" + subLevel, filterString, paramString, "String", "null", paramMap, "!=");
        this.appendNonNullParam("sub" + (subLevel + 1), filterString, paramString, "String", "null", paramMap, " == ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        List resultsGTE = (List)query.executeWithMap(paramMap);
        return resultsGTE;
    }

    public OGRFeature findByCountryAndType(String countryCode, OGRFeature.FeatureType featureType) {
        List<OGRFeature> results = this.listByCountryAndType(countryCode, featureType, null);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Deprecated
    public List<OGRFeature> listByCountryAndType(String countryCode, OGRFeature.FeatureType featureType) {
        return this.listByCountryAndType(countryCode, featureType, "all");
    }

    public List<OGRFeature> listByCountryAndType(String countryCode, OGRFeature.FeatureType featureType, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("featureType", filterString, paramString, "String", (Object)featureType, paramMap, " == ");
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap, " == ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        List results = (List)query.executeWithMap(paramMap);
        if (results != null && results.size() > 0) {
            return results;
        }
        return null;
    }

    public OGRFeature findByCountryTypeAndSub(String countryCode, String name, OGRFeature.FeatureType featureType, ArrayList<String> subArray) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(OGRFeature.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("featureType", filterString, paramString, "String", (Object)featureType, paramMap, " == ");
        this.appendNonNullParam("name", filterString, paramString, "String", name, paramMap, " == ");
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap, " == ");
        for (int i = 1; i < subArray.size() + 1; ++i) {
            this.appendNonNullParam("sub" + i, filterString, paramString, "String", subArray.get(i - 1), paramMap, " == ");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List results = (List)query.executeWithMap(paramMap);
        if (results != null && results.size() > 0) {
            return (OGRFeature)results.get(0);
        }
        return null;
    }

    @Override
    public OGRFeature save(OGRFeature item) {
        OGRFeature existingItem;
        if (item.getFeatureType().equals((Object)OGRFeature.FeatureType.COUNTRY)) {
            OGRFeature existingItem2 = this.findByCountryAndType(item.getCountryCode(), OGRFeature.FeatureType.COUNTRY);
            if (existingItem2 != null) {
                existingItem2.setGeometry(item.getGeometry());
                existingItem2.setBoundingBox(item.getBoundingBox());
                super.save(existingItem2);
                item = existingItem2;
            } else {
                super.save(item);
            }
            CountryDao countryDao = new CountryDao();
            Country country = countryDao.findByCode(item.getCountryCode());
            if (country == null) {
                country = new Country();
                country.setName(item.getName());
                country.setDisplayName(item.getName());
                country.setCentroidLat(item.getCentroidLat());
                country.setCentroidLon(item.getCentroidLon());
                country.setIsoAlpha2Code(item.getCountryCode());
                countryDao.save(country);
            } else if (country.getName() == null || country.getDisplayName() == null) {
                country.setName(item.getName());
                country.setDisplayName(item.getName());
                countryDao.save(country);
            }
            return item;
        }
        ArrayList<String> subList = new ArrayList<String>();
        if (item.getSub1() != null) {
            subList.add(item.getSub1());
        }
        if (item.getSub2() != null) {
            subList.add(item.getSub2());
        }
        if (item.getSub3() != null) {
            subList.add(item.getSub3());
        }
        if (item.getSub4() != null) {
            subList.add(item.getSub4());
        }
        if (item.getSub5() != null) {
            subList.add(item.getSub5());
        }
        if (item.getSub6() != null) {
            subList.add(item.getSub6());
        }
        if ((existingItem = this.findByCountryTypeAndSub(item.getCountryCode(), item.getName(), OGRFeature.FeatureType.SUB_COUNTRY_OTHER, subList)) != null) {
            boolean isSame = true;
            if (item.getSub1() != null && existingItem.getSub1() != null && !existingItem.getSub1().equals(item.getSub1())) {
                isSame = false;
            }
            if (item.getSub2() != null && existingItem.getSub2() != null && !existingItem.getSub2().equals(item.getSub2()) || item.getSub2() == null && existingItem.getSub2() != null) {
                isSame = false;
            }
            if (item.getSub3() != null && existingItem.getSub3() != null && !existingItem.getSub3().equals(item.getSub3())) {
                isSame = false;
            }
            if (item.getSub4() != null && existingItem.getSub4() != null && !existingItem.getSub4().equals(item.getSub4())) {
                isSame = false;
            }
            if (item.getSub5() != null && existingItem.getSub5() != null && !existingItem.getSub5().equals(item.getSub5())) {
                isSame = false;
            }
            if (item.getSub6() != null && existingItem.getSub6() != null && !existingItem.getSub6().equals(item.getSub6())) {
                isSame = false;
            }
            if (isSame) {
                existingItem.setGeometry(item.getGeometry());
                existingItem.setBoundingBox(item.getBoundingBox());
                existingItem.setCentroidLat(item.getCentroidLat());
                existingItem.setCentroidLon(item.getCentroidLon());
                super.save(existingItem);
                return existingItem;
            }
        }
        super.save(item);
        return item;
    }
}

