/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.akvo.flow.rest.form.QuestionGroupDtoMapper;
import org.akvo.flow.rest.form.TranslationsDtoMapper;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

public class FormDtoMapper {
    private final QuestionGroupDtoMapper questionGroupDtoMapper;
    private final TranslationsDtoMapper translationsDtoMapper;

    public FormDtoMapper(QuestionGroupDtoMapper questionGroupDtoMapper, TranslationsDtoMapper translationsDtoMapper) {
        this.questionGroupDtoMapper = questionGroupDtoMapper;
        this.translationsDtoMapper = translationsDtoMapper;
    }

    Survey assembleForm(SurveyDto surveyDto) {
        Survey form = this.mapFormFromDto(surveyDto);
        this.translationsDtoMapper.attachFormTranslations(form);
        List<Question> questions = this.getQuestionList(form.getQuestionGroupMap());
        this.attachCascadeResources(questions);
        return form;
    }

    Survey mapFormFromDto(SurveyDto surveyDto) {
        Survey form = new Survey();
        form.setKey(KeyFactory.createKey((String)"Survey", (long)surveyDto.getKeyId()));
        form.setCode(surveyDto.getCode());
        form.setName(surveyDto.getName());
        form.setVersion(Double.parseDouble(surveyDto.getVersion()));
        form.setDesc(surveyDto.getDescription());
        form.setStatus(Survey.Status.NOT_PUBLISHED);
        form.setPath(surveyDto.getPath());
        form.setSurveyGroupId(surveyDto.getSurveyGroupId());
        form.setDefaultLanguageCode(surveyDto.getDefaultLanguageCode());
        form.setRequireApproval(surveyDto.getRequireApproval());
        form.setCreatedDateTime(surveyDto.getCreatedDateTime());
        form.setLastUpdateDateTime(surveyDto.getLastUpdateDateTime());
        form.setAncestorIds(surveyDto.getAncestorIds());
        TreeMap<Integer, QuestionGroup> groupMap = this.questionGroupDtoMapper.mapGroups(surveyDto);
        form.setQuestionGroupMap(groupMap);
        return form;
    }

    void attachCascadeResources(List<Question> questions) {
        CascadeResourceDao cascadeResourceDao = new CascadeResourceDao();
        for (Question question : questions) {
            CascadeResource cascadeResource;
            if (!Question.Type.CASCADE.equals((Object)question.getType()) || (cascadeResource = (CascadeResource)cascadeResourceDao.getByKey(question.getCascadeResourceId())) == null) continue;
            question.setCascadeResource(cascadeResource.getResourceId());
            question.setLevelNames(cascadeResource.getLevelNames());
        }
    }

    @Nonnull
    List<Question> getQuestionList(@Nullable TreeMap<Integer, QuestionGroup> questionGroupTreeMap) {
        if (questionGroupTreeMap != null) {
            ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>(questionGroupTreeMap.values());
            return groups.stream().filter(it -> it.getQuestionMap() != null).map(this::getListOfQuestions).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    List<Question> getListOfQuestions(QuestionGroup questionGroup) {
        TreeMap<Integer, Question> questionMap = questionGroup.getQuestionMap();
        if (questionMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Question>(questionMap.values());
    }
}

