/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.xml.XmlAltText;

public class XmlHelp {
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private String type;
    @JacksonXmlProperty(localName="text", isAttribute=false)
    private String text;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;

    public XmlHelp() {
    }

    public XmlHelp(Question q) {
        this.text = q.getTip();
        if (this.altText == null) {
            this.altText = new ArrayList<XmlAltText>();
        }
        Map<String, Translation> translationMap = this.createTranslationsMap(q);
        for (Translation translation : translationMap.values()) {
            this.altText.add(new XmlAltText(translation));
        }
    }

    private Map<String, Translation> createTranslationsMap(Question q) {
        HashMap<String, Translation> translationMap = new HashMap<String, Translation>();
        List<Translation> translations = q.getTranslations();
        if (translations != null) {
            for (Translation t : translations) {
                if (!Translation.ParentType.QUESTION_TIP.equals((Object)t.getParentType())) continue;
                translationMap.put(t.getLanguageCode(), t);
            }
        }
        return translationMap;
    }

    public String toString() {
        return "help{type='" + this.type + "',text='" + this.text + "'}";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }
}

