/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.akvo.flow.util.ExifTagExtractor;
import org.akvo.flow.util.ExifTagInfo;
import org.akvo.flow.util.FileResponse;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

@Controller
@RequestMapping(value={"/image_upload"})
public class ImageUploadRestService {
    private static final Logger log = Logger.getLogger(ImageUploadRestService.class.getName());

    @RequestMapping(method={RequestMethod.POST}, value={"/question/{questionId}/instance/{instanceId}"})
    @ResponseBody
    public Response uploadImage(@PathVariable(value="questionId") Long questionId, @PathVariable(value="instanceId") Long formInstanceId, @RequestParam(value="image") MultipartFile file) {
        int responseCode = 200;
        String errorMessage = "";
        SurveyInstance formInstance = this.getFormInstance(formInstanceId);
        if (formInstance == null) {
            return new Response(400, "FormInstance not found");
        }
        long formId = formInstance.getSurveyId();
        Survey form = this.getForm(formId);
        if (form == null) {
            return new Response(400, "Form not found");
        }
        Question question = this.getQuestion(questionId);
        if (question == null) {
            return new Response(400, "Question not found");
        }
        if (question.getSurveyId() == null || !question.getSurveyId().equals(form.getObjectId())) {
            return new Response(400, "Question does not belong to that form");
        }
        if (file == null || file.isEmpty()) {
            return new Response(400, "File is not valid");
        }
        String fileExtension = this.getFileType(file);
        if (fileExtension == null) {
            return new Response(400, "File type is not valid: only jpg and png are accepted");
        }
        String originalFileName = file.getName();
        String filename = this.generateFileName(fileExtension);
        String resultFilename = this.uploadImageToS3(file, filename);
        if (resultFilename == null) {
            return new Response(400, "Upload to s3 failed for: " + originalFileName);
        }
        ExifTagExtractor exifTagExtractor = new ExifTagExtractor();
        ExifTagInfo exifTag = exifTagExtractor.fetchExifTags(file);
        this.createOrUpdateQuestionAnswer(question, formInstance, resultFilename, exifTag);
        return new Response(responseCode, errorMessage);
    }

    @Nullable
    private String getFileType(MultipartFile file) {
        String contentType;
        switch (contentType = file.getContentType() != null ? file.getContentType() : "") {
            case "image/jpeg": {
                return ".jpg";
            }
            case "image/png": {
                return ".png";
            }
        }
        return null;
    }

    @Nullable
    private String uploadImageToS3(MultipartFile file, String fileName) {
        try {
            Properties props = System.getProperties();
            String bucketName = props.getProperty("s3bucket");
            String directory = props.getProperty("images");
            S3Util.put(bucketName, directory + "/" + fileName, file.getBytes(), file.getContentType(), true);
            return fileName;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error uploading image", e);
            return null;
        }
    }

    private void createOrUpdateQuestionAnswer(Question question, SurveyInstance formInstance, String fileName, ExifTagInfo exifTag) {
        QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
        QuestionAnswerStore questionAnswerStore = questionAnswerStoreDao.getByQuestionAndSurveyInstance(question.getKey().getId(), formInstance.getKey().getId());
        if (questionAnswerStore == null) {
            questionAnswerStore = this.createQuestionAnswer(question, formInstance);
        }
        this.saveQuestionAnswer(formInstance, fileName, exifTag, questionAnswerStoreDao, questionAnswerStore);
    }

    private void saveQuestionAnswer(SurveyInstance formInstance, String fileName, ExifTagInfo exifTag, QuestionAnswerStoreDao questionAnswerStoreDao, QuestionAnswerStore store) {
        Date collectionDate;
        try {
            FileResponse fileResponse = new FileResponse(fileName, exifTag.getLocation());
            store.setValue(new FlowJsonObjectWriter().writeAsString(fileResponse));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error generating filename json");
            store.setValue(fileName);
        }
        Date date = collectionDate = exifTag != null ? exifTag.getCollectionDate() : null;
        if (collectionDate != null) {
            store.setCollectionDate(collectionDate);
        } else {
            store.setCollectionDate(formInstance.getCollectionDate());
        }
        questionAnswerStoreDao.save(store);
    }

    private QuestionAnswerStore createQuestionAnswer(Question question, SurveyInstance formInstance) {
        QuestionAnswerStore store = new QuestionAnswerStore();
        store.setSurveyId(formInstance.getSurveyId());
        store.setSurveyInstanceId(formInstance.getKey().getId());
        store.setQuestionID(question.getKey().getId() + "");
        store.setType("IMAGE");
        store.setIteration(0);
        return store;
    }

    private String generateFileName(String fileExtension) {
        return UUID.randomUUID().toString() + fileExtension;
    }

    private SurveyInstance getFormInstance(Long formInstanceId) {
        if (formInstanceId == null) {
            return null;
        }
        return (SurveyInstance)new SurveyInstanceDAO().getByKey(formInstanceId);
    }

    private Question getQuestion(Long questionId) {
        if (questionId == null) {
            return null;
        }
        return new QuestionDao().getByKey(questionId);
    }

    private Survey getForm(long formId) {
        return (Survey)new SurveyDAO().getByKey(formId);
    }

    public static class Response {
        private final int code;
        private final String message;

        public Response(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

