/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.domain.UserAuthorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.UserAuthorizationPayload;

@Controller
@RequestMapping(value={"/user_auth"})
public class UserAuthorizationRestService {
    private UserAuthorizationDAO userAuthorizationDAO = new UserAuthorizationDAO();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listAllUserAuthorizations() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List authorizationList = this.userAuthorizationDAO.list("all");
        ArrayList<UserAuthorizationPayload> responsePayloadList = new ArrayList<UserAuthorizationPayload>();
        for (UserAuthorization auth : authorizationList) {
            responsePayloadList.add(new UserAuthorizationPayload(auth));
        }
        response.put("user_auth", responsePayloadList);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> createUserAuthorization(@RequestBody UserAuthorizationPayload requestPayload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserAuthorization newAuth = requestPayload.getUserAuthorisation();
        UserAuthorization existingAuth = this.userAuthorizationDAO.findUserAuthorization(newAuth.getUserId(), newAuth.getRoleId(), newAuth.getSecuredObjectId());
        UserAuthorizationPayload responsePayload = null;
        responsePayload = existingAuth != null ? new UserAuthorizationPayload(existingAuth) : new UserAuthorizationPayload(this.userAuthorizationDAO.save(newAuth));
        response.put("user_auth", responsePayload);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{authId}"})
    @ResponseBody
    public Map<String, Object> updateUserAuthorization(@RequestBody UserAuthorizationPayload requestPayload, @PathVariable Long authId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserAuthorization existingAuth = (UserAuthorization)this.userAuthorizationDAO.getByKey(authId);
        if (existingAuth != null) {
            BeanUtils.copyProperties((Object)requestPayload, (Object)existingAuth, (String[])new String[]{"userId"});
            response.put("user_auth", new UserAuthorizationPayload(existingAuth));
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{authId}"})
    @ResponseBody
    public void deleteUserAuthorization(@PathVariable Long authId) {
        UserAuthorization existingAuth = (UserAuthorization)this.userAuthorizationDAO.getByKey(authId);
        this.userAuthorizationDAO.delete(existingAuth);
    }
}

